/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.dependencygraphs;

import java.time.temporal.ChronoUnit;
import kieker.analysisteetime.statistics.IProperty;
import kieker.analysisteetime.statistics.Properties;
import kieker.analysisteetime.statistics.StatisticsModel;
import kieker.analysisteetime.statistics.Units;
import kieker.analysisteetime.util.graph.IVertex;
import kieker.analysisteetime.util.time.ChronoUnitToSymbolMapper;

public class ResponseTimeDecorator {
    private final StatisticsModel statisticsModel;
    private final String timeUnit;

    public ResponseTimeDecorator(StatisticsModel statisticsModel, ChronoUnit chronoUnit) {
        this.statisticsModel = statisticsModel;
        this.timeUnit = ChronoUnitToSymbolMapper.create().apply(chronoUnit);
    }

    public void decorate(IVertex vertex, Object object) {
        vertex.setPropertyIfAbsent("min response time", this.getStatisticValue(object, Properties.MIN));
        vertex.setPropertyIfAbsent("max response time", this.getStatisticValue(object, Properties.MAX));
        vertex.setPropertyIfAbsent("total response time", this.getStatisticValue(object, Properties.TOTAL));
        vertex.setPropertyIfAbsent("mean response time", this.getStatisticValue(object, Properties.AVERAGE));
        vertex.setPropertyIfAbsent("median response time", this.getStatisticValue(object, Properties.MEDIAN));
        vertex.setPropertyIfAbsent("time unit", this.timeUnit);
    }

    private long getStatisticValue(Object object, IProperty property) {
        Long value;
        if (this.statisticsModel.has(object) && (value = this.statisticsModel.get(object).getStatistic(Units.RESPONSE_TIME).getProperty(property)) != null) {
            return value;
        }
        return 0L;
    }
}

