/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.dependencygraphs;

import kieker.analysisteetime.dependencygraphs.AbstractDependencyGraphBuilder;
import kieker.analysisteetime.dependencygraphs.vertextypes.VertexType;
import kieker.analysisteetime.model.analysismodel.deployment.DeployedOperation;
import kieker.analysisteetime.model.analysismodel.execution.ExecutionModel;
import kieker.analysisteetime.model.analysismodel.type.ComponentType;
import kieker.analysisteetime.model.analysismodel.type.OperationType;
import kieker.analysisteetime.statistics.StatisticsModel;
import kieker.analysisteetime.util.graph.IGraph;
import kieker.analysisteetime.util.graph.IVertex;

public class TypeLevelOperationDependencyGraphBuilder
extends AbstractDependencyGraphBuilder {
    public TypeLevelOperationDependencyGraphBuilder(ExecutionModel executionModel, StatisticsModel statisticsModel) {
        super(executionModel, statisticsModel);
    }

    @Override
    protected IVertex addVertex(DeployedOperation deployedOperation) {
        OperationType operation = deployedOperation.getAssemblyOperation().getOperationType();
        ComponentType component = operation.getComponentType();
        int componentId = this.identifierRegistry.getIdentifier(component);
        IVertex componentVertex = this.graph.addVertexIfAbsent(componentId);
        componentVertex.setPropertyIfAbsent("type", (Object)VertexType.COMPONENT_TYPE);
        componentVertex.setPropertyIfAbsent("name", component.getName());
        componentVertex.setPropertyIfAbsent("package name", component.getPackage());
        IGraph componentSubgraph = componentVertex.addChildGraphIfAbsent();
        int operationId = this.identifierRegistry.getIdentifier(operation);
        IVertex operationVertex = componentSubgraph.addVertexIfAbsent(operationId);
        operationVertex.setPropertyIfAbsent("type", (Object)VertexType.OPERATION_TYPE);
        operationVertex.setPropertyIfAbsent("name", operation.getName());
        operationVertex.setPropertyIfAbsent("return type", operation.getReturnType());
        operationVertex.setPropertyIfAbsent("modifiers", operation.getModifiers());
        operationVertex.setPropertyIfAbsent("parameter types", operation.getParameterTypes());
        this.responseTimeDecorator.decorate(operationVertex, operation);
        return operationVertex;
    }
}

