/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.dependencygraphs.dot;

import java.util.Collection;
import kieker.analysisteetime.dependencygraphs.vertextypes.IVertexTypeMapper;
import kieker.analysisteetime.dependencygraphs.vertextypes.VertexType;
import kieker.analysisteetime.signature.NameBuilder;
import kieker.analysisteetime.util.graph.IElement;
import kieker.analysisteetime.util.graph.IVertex;
import kieker.analysisteetime.util.graph.export.dot.DotExportConfiguration;
import kieker.analysisteetime.util.graph.util.dot.attributes.DotClusterAttribute;
import kieker.analysisteetime.util.graph.util.dot.attributes.DotEdgeAttribute;
import kieker.analysisteetime.util.graph.util.dot.attributes.DotGraphAttribute;
import kieker.analysisteetime.util.graph.util.dot.attributes.DotNodeAttribute;

public class DotExportConfigurationFactory {
    private static final String ENTRY_LABEL = "'Entry'";
    private final NameBuilder nameBuilder;
    private final IVertexTypeMapper vertexTypeMapper;

    public DotExportConfigurationFactory(NameBuilder nameBuilder) {
        this(nameBuilder, IVertexTypeMapper.TO_STRING);
    }

    public DotExportConfigurationFactory(NameBuilder nameBuilder, IVertexTypeMapper vertexTypeMapper) {
        this.nameBuilder = nameBuilder;
        this.vertexTypeMapper = vertexTypeMapper;
    }

    private DotExportConfiguration.Builder createBaseBuilder() {
        DotExportConfiguration.Builder builder = new DotExportConfiguration.Builder();
        builder.addGraphAttribute(DotGraphAttribute.RANKDIR, g -> "LR");
        builder.addDefaultEdgeAttribute(DotEdgeAttribute.STYLE, g -> "solid");
        builder.addDefaultEdgeAttribute(DotEdgeAttribute.ARROWHEAD, g -> "open");
        builder.addDefaultEdgeAttribute(DotEdgeAttribute.COLOR, g -> "#000000");
        builder.addDefaultNodeAttribute(DotNodeAttribute.STYLE, g -> "filled");
        builder.addDefaultNodeAttribute(DotNodeAttribute.COLOR, g -> "#000000");
        builder.addDefaultNodeAttribute(DotNodeAttribute.FILLCOLOR, g -> "white");
        builder.addEdgeAttribute(DotEdgeAttribute.LABEL, e -> this.getProperty((IElement)e, "calls").toString());
        builder.addClusterAttribute(DotClusterAttribute.STYLE, v -> "filled");
        builder.addClusterAttribute(DotClusterAttribute.FILLCOLOR, v -> "white");
        return builder;
    }

    public DotExportConfiguration createForTypeLevelOperationDependencyGraph() {
        DotExportConfiguration.Builder builder = this.createBaseBuilder();
        builder.addDefaultNodeAttribute(DotNodeAttribute.SHAPE, v -> "oval");
        builder.addNodeAttribute(DotNodeAttribute.LABEL, v -> {
            VertexType type = this.getProperty((IElement)v, "type", (Class)VertexType.class);
            if (type == VertexType.ENTRY) {
                return ENTRY_LABEL;
            }
            return this.createOperationLabelFromVertex((IVertex)v) + "\\n" + this.createStatisticsFromVertex((IVertex)v);
        });
        builder.addClusterAttribute(DotClusterAttribute.LABEL, v -> this.createComponentLabelFromVertex((IVertex)v).toString());
        return builder.build();
    }

    public DotExportConfiguration createForTypeLevelComponentDependencyGraph() {
        DotExportConfiguration.Builder builder = this.createBaseBuilder();
        builder.addDefaultNodeAttribute(DotNodeAttribute.SHAPE, v -> "box");
        builder.addNodeAttribute(DotNodeAttribute.LABEL, v -> {
            VertexType type = this.getProperty((IElement)v, "type", (Class)VertexType.class);
            if (type == VertexType.ENTRY) {
                return ENTRY_LABEL;
            }
            return this.createComponentLabelFromVertex((IVertex)v) + "\\n" + this.createStatisticsFromVertex((IVertex)v);
        });
        return builder.build();
    }

    public DotExportConfiguration createForAssemblyLevelOperationDependencyGraph() {
        DotExportConfiguration.Builder builder = this.createBaseBuilder();
        builder.addDefaultNodeAttribute(DotNodeAttribute.SHAPE, v -> "oval");
        builder.addNodeAttribute(DotNodeAttribute.LABEL, v -> {
            VertexType type = this.getProperty((IElement)v, "type", (Class)VertexType.class);
            if (type == VertexType.ENTRY) {
                return ENTRY_LABEL;
            }
            return this.createOperationLabelFromVertex((IVertex)v) + "\\n" + this.createStatisticsFromVertex((IVertex)v);
        });
        builder.addClusterAttribute(DotClusterAttribute.LABEL, v -> this.createComponentLabelFromVertex((IVertex)v).toString());
        return builder.build();
    }

    public DotExportConfiguration createForAssemblyLevelComponentDependencyGraph() {
        DotExportConfiguration.Builder builder = this.createBaseBuilder();
        builder.addDefaultNodeAttribute(DotNodeAttribute.SHAPE, v -> "box");
        builder.addNodeAttribute(DotNodeAttribute.LABEL, v -> {
            VertexType type = this.getProperty((IElement)v, "type", (Class)VertexType.class);
            if (type == VertexType.ENTRY) {
                return ENTRY_LABEL;
            }
            return this.createComponentLabelFromVertex((IVertex)v) + "\\n" + this.createStatisticsFromVertex((IVertex)v);
        });
        return builder.build();
    }

    public DotExportConfiguration createForDeploymentLevelOperationDependencyGraph() {
        DotExportConfiguration.Builder builder = this.createBaseBuilder();
        builder.addDefaultNodeAttribute(DotNodeAttribute.SHAPE, v -> "oval");
        builder.addNodeAttribute(DotNodeAttribute.LABEL, v -> {
            VertexType type = this.getProperty((IElement)v, "type", (Class)VertexType.class);
            if (type == VertexType.ENTRY) {
                return ENTRY_LABEL;
            }
            return this.createOperationLabelFromVertex((IVertex)v) + "\\n" + this.createStatisticsFromVertex((IVertex)v);
        });
        builder.addClusterAttribute(DotClusterAttribute.LABEL, v -> {
            VertexType type = this.getProperty((IElement)v, "type", (Class)VertexType.class);
            switch (type) {
                case DEPLOYMENT_CONTEXT: {
                    return this.createContextLabelFromVertex((IVertex)v).toString();
                }
                case DEPLOYED_COMPONENT: {
                    return this.createComponentLabelFromVertex((IVertex)v).toString();
                }
            }
            throw new IllegalArgumentException("Type '" + type.toString() + "' is not supported for this dependency graph.");
        });
        return builder.build();
    }

    public DotExportConfiguration createForDeploymentLevelComponentDependencyGraph() {
        DotExportConfiguration.Builder builder = this.createBaseBuilder();
        builder.addDefaultNodeAttribute(DotNodeAttribute.SHAPE, v -> "box");
        builder.addNodeAttribute(DotNodeAttribute.LABEL, v -> {
            VertexType type = this.getProperty((IElement)v, "type", (Class)VertexType.class);
            if (type == VertexType.ENTRY) {
                return ENTRY_LABEL;
            }
            return this.createComponentLabelFromVertex((IVertex)v) + "\\n" + this.createStatisticsFromVertex((IVertex)v);
        });
        builder.addClusterAttribute(DotClusterAttribute.LABEL, v -> this.createContextLabelFromVertex((IVertex)v).toString());
        return builder.build();
    }

    public DotExportConfiguration createForDeploymentLevelContextDependencyGraph() {
        DotExportConfiguration.Builder builder = this.createBaseBuilder();
        builder.addDefaultNodeAttribute(DotNodeAttribute.SHAPE, v -> "box3d");
        builder.addNodeAttribute(DotNodeAttribute.LABEL, v -> {
            VertexType type = this.getProperty((IElement)v, "type", (Class)VertexType.class);
            if (type == VertexType.ENTRY) {
                return ENTRY_LABEL;
            }
            return this.createContextLabelFromVertex((IVertex)v).toString();
        });
        return builder.build();
    }

    private StringBuilder createType(VertexType type) {
        return new StringBuilder().append("<<").append((String)this.vertexTypeMapper.apply(type)).append(">>");
    }

    private StringBuilder createOperationLabelFromVertex(IVertex vertex) {
        Collection modifiers = this.getProperty(vertex, "modifiers", Collection.class);
        String returnType = this.getProperty(vertex, "return type", String.class);
        String name = this.getProperty(vertex, "name", String.class);
        Collection parameterTypes = this.getProperty(vertex, "parameter types", Collection.class);
        return new StringBuilder(this.nameBuilder.getOperationNameBuilder().build(modifiers, returnType, name, parameterTypes));
    }

    private StringBuilder createComponentLabelFromVertex(IVertex vertex) {
        VertexType type = this.getProperty(vertex, "type", VertexType.class);
        String name = this.getProperty(vertex, "name", String.class);
        String packageName = this.getProperty(vertex, "package name", String.class);
        return new StringBuilder().append((CharSequence)this.createType(type)).append("\\n").append(this.nameBuilder.getComponentNameBuilder().build(packageName, name));
    }

    private StringBuilder createContextLabelFromVertex(IVertex vertex) {
        VertexType type = this.getProperty(vertex, "type", VertexType.class);
        String name = this.getProperty(vertex, "name", String.class);
        return new StringBuilder().append((CharSequence)this.createType(type)).append("\\n").append(name);
    }

    private StringBuilder createStatisticsFromVertex(IVertex vertex) {
        String timeUnit = this.getProperty(vertex, "time unit").toString();
        String minResponseTime = this.getProperty(vertex, "min response time").toString();
        String maxResponseTime = this.getProperty(vertex, "max response time").toString();
        String totalResponseTime = this.getProperty(vertex, "total response time").toString();
        String meanResponseTime = this.getProperty(vertex, "mean response time").toString();
        String medianResponseTime = this.getProperty(vertex, "median response time").toString();
        return this.createStatistics(timeUnit, minResponseTime, maxResponseTime, totalResponseTime, meanResponseTime, medianResponseTime);
    }

    private StringBuilder createStatistics(String timeUnit, String minResponseTime, String maxResponseTime, String totalResponseTime, String meanResponseTime, String medianResponseTime) {
        return new StringBuilder().append("min: ").append(minResponseTime).append(' ').append(timeUnit).append(", ").append("max: ").append(maxResponseTime).append(' ').append(timeUnit).append(", ").append("total: ").append(totalResponseTime).append(' ').append(timeUnit).append(",\\n").append("avg: ").append(meanResponseTime).append(' ').append(timeUnit).append(", ").append("median: ").append(medianResponseTime).append(' ').append(timeUnit);
    }

    private Object getProperty(IElement element, String key) {
        Object object = element.getProperty(key);
        if (object == null) {
            throw new IllegalArgumentException("There is no key '" + key + "' for element '" + element + "'");
        }
        return object;
    }

    private <T> T getProperty(IElement element, String key, Class<T> clazz) {
        Object object = this.getProperty(element, key);
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException("Object with key '" + key + "' is not of type '" + clazz + "'");
        }
        return clazz.cast(object);
    }
}

