/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.experimental;

import java.io.PrintStream;
import kieker.analysisteetime.util.graph.Direction;
import kieker.analysisteetime.util.graph.IEdge;
import kieker.analysisteetime.util.graph.IGraph;
import kieker.analysisteetime.util.graph.IVertex;
import teetime.framework.AbstractConsumerStage;

public class GraphPrinterStage
extends AbstractConsumerStage<IGraph> {
    private final PrintStream printStream;

    public GraphPrinterStage() {
        this(System.out);
    }

    public GraphPrinterStage(PrintStream printStream) {
        this.printStream = printStream;
    }

    protected void execute(IGraph graph) {
        for (IVertex vertex : graph.getVertices()) {
            this.printStream.println("Vertices:");
            this.printStream.println(vertex.getId());
            this.printStream.println("    Vertices:");
            for (IVertex vertex1 : vertex.getChildGraph().getVertices()) {
                this.printStream.println("    " + vertex1.getId());
                this.printStream.println("        Vertices:");
                for (IVertex vertex2 : vertex1.getChildGraph().getVertices()) {
                    this.printStream.println("        " + vertex2.getId());
                }
                this.printStream.println("        Edges:");
                for (IEdge edge2 : vertex1.getChildGraph().getEdges()) {
                    this.printStream.println("        " + edge2.getVertex(Direction.OUT).getId() + "->" + edge2.getVertex(Direction.IN).getId());
                }
            }
            this.printStream.println("    Edges:");
            for (IEdge edge1 : vertex.getChildGraph().getEdges()) {
                this.printStream.println("    " + edge1.getVertex(Direction.OUT).getId() + "->" + edge1.getVertex(Direction.IN).getId());
            }
        }
        this.printStream.println("Edges:");
        for (IEdge edge : graph.getEdges()) {
            this.printStream.println(edge.getVertex(Direction.OUT).getId() + "->" + edge.getVertex(Direction.IN).getId());
        }
    }
}

