/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.experimental.hotspotdetection;

import java.io.File;
import java.time.temporal.ChronoUnit;
import kieker.analysisteetime.experimental.hotspotdetection.HotspotDetectionStage;
import kieker.analysisteetime.model.AssemblyModelAssemblerStage;
import kieker.analysisteetime.model.DeploymentModelAssemblerStage;
import kieker.analysisteetime.model.TypeModelAssemblerStage;
import kieker.analysisteetime.model.analysismodel.assembly.AssemblyFactory;
import kieker.analysisteetime.model.analysismodel.assembly.AssemblyModel;
import kieker.analysisteetime.model.analysismodel.deployment.DeploymentFactory;
import kieker.analysisteetime.model.analysismodel.deployment.DeploymentModel;
import kieker.analysisteetime.model.analysismodel.type.TypeFactory;
import kieker.analysisteetime.model.analysismodel.type.TypeModel;
import kieker.analysisteetime.recordreading.ReadingComposite;
import kieker.analysisteetime.signature.JavaComponentSignatureExtractor;
import kieker.analysisteetime.signature.JavaOperationSignatureExtractor;
import kieker.analysisteetime.trace.reconstruction.TraceReconstructorStage;
import kieker.common.record.flow.IFlowRecord;
import teetime.framework.Configuration;
import teetime.stage.InstanceOfFilter;

public class HotspotDetectionConfiguration
extends Configuration {
    public HotspotDetectionConfiguration(File importDirectory) {
        TypeModel typeModel = TypeFactory.eINSTANCE.createTypeModel();
        AssemblyModel assemblyModel = AssemblyFactory.eINSTANCE.createAssemblyModel();
        DeploymentModel deploymentModel = DeploymentFactory.eINSTANCE.createDeploymentModel();
        ReadingComposite reader = new ReadingComposite(importDirectory);
        InstanceOfFilter instanceOfFilter = new InstanceOfFilter(IFlowRecord.class);
        TypeModelAssemblerStage typeModelAssembler = new TypeModelAssemblerStage(typeModel, new JavaComponentSignatureExtractor(), new JavaOperationSignatureExtractor());
        AssemblyModelAssemblerStage assemblyModelAssembler = new AssemblyModelAssemblerStage(typeModel, assemblyModel);
        DeploymentModelAssemblerStage deploymentModelAssembler = new DeploymentModelAssemblerStage(assemblyModel, deploymentModel);
        TraceReconstructorStage traceReconstructor = new TraceReconstructorStage(deploymentModel, ChronoUnit.NANOS);
        HotspotDetectionStage hotspotDetector = new HotspotDetectionStage();
        super.connectPorts(reader.getOutputPort(), instanceOfFilter.getInputPort());
        super.connectPorts(instanceOfFilter.getMatchedOutputPort(), typeModelAssembler.getInputPort());
        super.connectPorts(typeModelAssembler.getOutputPort(), assemblyModelAssembler.getInputPort());
        super.connectPorts(assemblyModelAssembler.getOutputPort(), deploymentModelAssembler.getInputPort());
        super.connectPorts(deploymentModelAssembler.getOutputPort(), traceReconstructor.getInputPort());
        super.connectPorts(traceReconstructor.getOutputPort(), hotspotDetector.getInputPort());
    }
}

