/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.model;

import kieker.analysisteetime.model.analysismodel.assembly.AssemblyComponent;
import kieker.analysisteetime.model.analysismodel.assembly.AssemblyFactory;
import kieker.analysisteetime.model.analysismodel.assembly.AssemblyModel;
import kieker.analysisteetime.model.analysismodel.assembly.AssemblyOperation;
import kieker.analysisteetime.model.analysismodel.type.ComponentType;
import kieker.analysisteetime.model.analysismodel.type.OperationType;
import kieker.analysisteetime.model.analysismodel.type.TypeModel;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;

public class AssemblyModelAssembler {
    private final AssemblyFactory factory = AssemblyFactory.eINSTANCE;
    private final TypeModel typeModel;
    private final AssemblyModel assemblyModel;

    public AssemblyModelAssembler(TypeModel typeModel, AssemblyModel assemblyModel) {
        this.typeModel = typeModel;
        this.assemblyModel = assemblyModel;
    }

    public void addRecord(BeforeOperationEvent record) {
        String classSignature = record.getClassSignature();
        String operationSignature = record.getOperationSignature();
        this.addRecord(classSignature, operationSignature);
    }

    public void addRecord(String componentSignature, String operationSignature) {
        AssemblyComponent component = this.addAssemblyComponent(componentSignature);
        this.addAssemblyOperation(component, operationSignature);
    }

    private AssemblyComponent addAssemblyComponent(String componentSignature) {
        String componentKey = componentSignature;
        AssemblyComponent component = (AssemblyComponent)this.assemblyModel.getAssemblyComponents().get((Object)componentKey);
        if (component == null) {
            component = this.factory.createAssemblyComponent();
            this.assemblyModel.getAssemblyComponents().put((Object)componentKey, (Object)component);
            String componentTypeKey = componentSignature;
            ComponentType componentType = (ComponentType)this.typeModel.getComponentTypes().get((Object)componentTypeKey);
            component.setComponentType(componentType);
        }
        return component;
    }

    private AssemblyOperation addAssemblyOperation(AssemblyComponent component, String operationSignature) {
        String operationKey = operationSignature;
        AssemblyOperation operation = (AssemblyOperation)component.getAssemblyOperations().get((Object)operationKey);
        if (operation == null) {
            operation = this.factory.createAssemblyOperation();
            component.getAssemblyOperations().put((Object)operationKey, (Object)operation);
            ComponentType componentType = component.getComponentType();
            String operationTypeKey = operationSignature;
            OperationType operationType = (OperationType)componentType.getProvidedOperations().get((Object)operationTypeKey);
            operation.setOperationType(operationType);
        }
        return operation;
    }
}

