/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.model;

import kieker.analysisteetime.HostnameRepository;
import kieker.analysisteetime.model.analysismodel.assembly.AssemblyComponent;
import kieker.analysisteetime.model.analysismodel.assembly.AssemblyModel;
import kieker.analysisteetime.model.analysismodel.assembly.AssemblyOperation;
import kieker.analysisteetime.model.analysismodel.deployment.DeployedComponent;
import kieker.analysisteetime.model.analysismodel.deployment.DeployedOperation;
import kieker.analysisteetime.model.analysismodel.deployment.DeploymentContext;
import kieker.analysisteetime.model.analysismodel.deployment.DeploymentFactory;
import kieker.analysisteetime.model.analysismodel.deployment.DeploymentModel;
import kieker.common.record.flow.trace.TraceMetadata;
import kieker.common.record.flow.trace.operation.AbstractOperationEvent;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;

public class DeploymentModelAssembler {
    private final DeploymentFactory factory = DeploymentFactory.eINSTANCE;
    private final HostnameRepository hostnameRepository = new HostnameRepository();
    private final AssemblyModel assemblyModel;
    private final DeploymentModel deploymentModel;

    public DeploymentModelAssembler(AssemblyModel assemblyModel, DeploymentModel deploymentModel) {
        this.assemblyModel = assemblyModel;
        this.deploymentModel = deploymentModel;
    }

    public void handleMetadataRecord(TraceMetadata metadata) {
        String hostname = metadata.getHostname();
        long traceId = metadata.getTraceId();
        this.hostnameRepository.addEntry(traceId, hostname);
    }

    public void handleBeforeOperationEvent(BeforeOperationEvent event) {
        this.hostnameRepository.inc(event.getTraceId());
        this.addRecord(event);
    }

    public void handleAfterOperationEvent(AfterOperationEvent event) {
        this.hostnameRepository.dec(event.getTraceId());
    }

    private void addRecord(AbstractOperationEvent record) {
        String hostname = this.hostnameRepository.getHostname(record.getTraceId());
        String classSignature = record.getClassSignature();
        String operationSignature = record.getOperationSignature();
        this.addRecord(hostname, classSignature, operationSignature);
    }

    private void addRecord(String hostname, String componentSignature, String operationSignature) {
        DeploymentContext deploymentContext = this.addDeploymentContext(hostname);
        DeployedComponent component = this.addDeployedComponent(deploymentContext, componentSignature);
        this.addDeployedOperation(component, operationSignature);
    }

    private DeploymentContext addDeploymentContext(String hostname) {
        String deploymentContextKey = hostname;
        DeploymentContext deploymentContext = (DeploymentContext)this.deploymentModel.getDeploymentContexts().get((Object)deploymentContextKey);
        if (deploymentContext == null) {
            deploymentContext = this.factory.createDeploymentContext();
            deploymentContext.setName(hostname);
            this.deploymentModel.getDeploymentContexts().put((Object)deploymentContextKey, (Object)deploymentContext);
        }
        return deploymentContext;
    }

    private DeployedComponent addDeployedComponent(DeploymentContext deploymentContext, String componentSignature) {
        String componentKey = componentSignature;
        DeployedComponent component = (DeployedComponent)deploymentContext.getComponents().get((Object)componentKey);
        if (component == null) {
            component = this.factory.createDeployedComponent();
            deploymentContext.getComponents().put((Object)componentKey, (Object)component);
            String componentTypeKey = componentSignature;
            AssemblyComponent assemblyComponent = (AssemblyComponent)this.assemblyModel.getAssemblyComponents().get((Object)componentTypeKey);
            component.setAssemblyComponent(assemblyComponent);
        }
        return component;
    }

    private DeployedOperation addDeployedOperation(DeployedComponent component, String operationSignature) {
        String operationKey = operationSignature;
        DeployedOperation operation = (DeployedOperation)component.getContainedOperations().get((Object)operationKey);
        if (operation == null) {
            operation = this.factory.createDeployedOperation();
            component.getContainedOperations().put((Object)operationKey, (Object)operation);
            AssemblyComponent assemblyComponent = component.getAssemblyComponent();
            String operationTypeKey = operationSignature;
            AssemblyOperation assemblyOperation = (AssemblyOperation)assemblyComponent.getAssemblyOperations().get((Object)operationTypeKey);
            operation.setAssemblyOperation(assemblyOperation);
        }
        return operation;
    }
}

