/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.model;

import java.io.PrintStream;
import kieker.analysisteetime.model.analysismodel.deployment.DeployedComponent;
import kieker.analysisteetime.model.analysismodel.deployment.DeployedOperation;
import kieker.analysisteetime.model.analysismodel.deployment.DeploymentContext;
import kieker.analysisteetime.model.analysismodel.deployment.DeploymentModel;

public class DeploymentModelPrinter {
    private static final String INSERTION = "    ";
    private final PrintStream printStream;

    public DeploymentModelPrinter(PrintStream printStream) {
        this.printStream = printStream;
    }

    public void print(DeploymentModel model) {
        for (DeploymentContext deploymentContext : model.getDeploymentContexts().values()) {
            this.printDeploymentContext(deploymentContext);
            for (DeployedComponent component : deploymentContext.getComponents().values()) {
                this.printComponent(component);
                for (DeployedOperation operation : component.getContainedOperations().values()) {
                    this.printOperation(operation);
                }
            }
        }
    }

    private void printDeploymentContext(DeploymentContext deploymentContext) {
        String name = deploymentContext.getName();
        this.printStream.println(name);
    }

    private void printComponent(DeployedComponent component) {
        String name = component.getAssemblyComponent().getComponentType().getSignature();
        this.printStream.println(INSERTION + name);
    }

    private void printOperation(DeployedOperation operation) {
        String name = operation.getAssemblyOperation().getOperationType().getSignature();
        this.printStream.println("        " + name);
    }
}

