/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.model;

import kieker.analysisteetime.model.analysismodel.deployment.DeployedOperation;
import kieker.analysisteetime.model.analysismodel.execution.AggregatedInvocation;
import kieker.analysisteetime.model.analysismodel.execution.ExecutionFactory;
import kieker.analysisteetime.model.analysismodel.execution.ExecutionModel;
import kieker.analysisteetime.model.analysismodel.trace.OperationCall;
import kieker.analysisteetime.util.ComposedKey;

public class ExecutionModelAssembler {
    private final ExecutionFactory factory = ExecutionFactory.eINSTANCE;
    private final ExecutionModel executionModel;

    public ExecutionModelAssembler(ExecutionModel executionModel) {
        this.executionModel = executionModel;
    }

    public void addOperationCall(OperationCall operationCall) {
        DeployedOperation source = operationCall.getParent() != null ? operationCall.getParent().getOperation() : null;
        DeployedOperation target = operationCall.getOperation();
        this.addExecution(source, target);
    }

    protected void addExecution(DeployedOperation source, DeployedOperation target) {
        ComposedKey<DeployedOperation, DeployedOperation> key = ComposedKey.of(source, target);
        if (!this.executionModel.getAggregatedInvocations().containsKey(key)) {
            AggregatedInvocation invocation = this.factory.createAggregatedInvocation();
            invocation.setSource(source);
            invocation.setTarget(target);
            this.executionModel.getAggregatedInvocations().put(key, (Object)invocation);
        }
    }
}

