/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.model;

import kieker.analysisteetime.model.analysismodel.type.ComponentType;
import kieker.analysisteetime.model.analysismodel.type.OperationType;
import kieker.analysisteetime.model.analysismodel.type.TypeFactory;
import kieker.analysisteetime.model.analysismodel.type.TypeModel;
import kieker.analysisteetime.signature.IComponentSignatureExtractor;
import kieker.analysisteetime.signature.IOperationSignatureExtractor;
import kieker.common.record.flow.IOperationRecord;

public class TypeModelAssembler {
    private final TypeFactory factory = TypeFactory.eINSTANCE;
    private final IComponentSignatureExtractor componentSignatureExtractor;
    private final IOperationSignatureExtractor operationSignatureExtractor;
    private final TypeModel typeModel;

    public TypeModelAssembler(TypeModel typeModel, IComponentSignatureExtractor componentSignatureExtractor, IOperationSignatureExtractor operationSignatureExtractor) {
        this.typeModel = typeModel;
        this.componentSignatureExtractor = componentSignatureExtractor;
        this.operationSignatureExtractor = operationSignatureExtractor;
    }

    public void addRecord(IOperationRecord record) {
        String classSignature = record.getClassSignature();
        String operationSignature = record.getOperationSignature();
        this.addRecord(classSignature, operationSignature);
    }

    public void addRecord(String componentSignature, String operationSignature) {
        ComponentType componentType = this.addComponentType(componentSignature);
        this.addOperationType(componentType, operationSignature);
    }

    private ComponentType addComponentType(String componentSignature) {
        String componentTypeKey = componentSignature;
        ComponentType componentType = (ComponentType)this.typeModel.getComponentTypes().get((Object)componentTypeKey);
        if (componentType == null) {
            componentType = this.factory.createComponentType();
            componentType.setSignature(componentSignature);
            this.componentSignatureExtractor.extract(componentType);
            this.typeModel.getComponentTypes().put((Object)componentTypeKey, (Object)componentType);
        }
        return componentType;
    }

    private OperationType addOperationType(ComponentType componentType, String operationSignature) {
        String operationTypeKey = operationSignature;
        OperationType operationType = (OperationType)componentType.getProvidedOperations().get((Object)operationSignature);
        if (operationType == null) {
            operationType = this.factory.createOperationType();
            operationType.setSignature(operationSignature);
            this.operationSignatureExtractor.extract(operationType);
            componentType.getProvidedOperations().put((Object)operationTypeKey, (Object)operationType);
        }
        return operationType;
    }
}

