/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.plugin.filter.forward;

import java.util.concurrent.TimeUnit;
import kieker.analysis.display.PlainText;
import kieker.common.record.IMonitoringRecord;
import teetime.framework.AbstractStage;
import teetime.framework.InputPort;
import teetime.framework.OutputPort;

public class AnalysisThroughputFilter
extends AbstractStage {
    private final InputPort<IMonitoringRecord> recordsInputPort = this.createInputPort();
    private final InputPort<Long> timestampsInputPort = this.createInputPort();
    private final OutputPort<IMonitoringRecord> recordsOutputPort = this.createOutputPort();
    private final OutputPort<Long> recordsCountOutputPort = this.createOutputPort();
    private long numPassedElements;
    private long lastTimestampInNs;
    private final PlainText plainTextDisplayObject = new PlainText();

    protected void execute() {
        Long timestampInNs;
        IMonitoringRecord record = (IMonitoringRecord)this.recordsInputPort.receive();
        if (record != null) {
            ++this.numPassedElements;
            this.recordsOutputPort.send((Object)record);
        }
        if ((timestampInNs = (Long)this.timestampsInputPort.receive()) != null) {
            long duration = timestampInNs - this.lastTimestampInNs;
            StringBuilder sb = new StringBuilder(256).append(this.numPassedElements).append(" objects within ").append(duration).append(' ').append(TimeUnit.NANOSECONDS.toString());
            this.plainTextDisplayObject.setText(sb.toString());
            this.recordsCountOutputPort.send((Object)this.numPassedElements);
            this.resetTimestamp(timestampInNs);
        }
    }

    protected void onStarting() {
        super.onStarting();
        this.resetTimestamp(System.nanoTime());
    }

    private void resetTimestamp(Long timestampInNs) {
        this.numPassedElements = 0L;
        this.lastTimestampInNs = timestampInNs;
    }

    public InputPort<IMonitoringRecord> getRecordsInputPort() {
        return this.recordsInputPort;
    }

    public InputPort<Long> getTimestampsInputPort() {
        return this.timestampsInputPort;
    }

    public OutputPort<IMonitoringRecord> getRecordsOutputPort() {
        return this.recordsOutputPort;
    }

    public OutputPort<Long> getRecordsCountOutputPort() {
        return this.recordsCountOutputPort;
    }
}

