/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.plugin.filter.forward;

import java.util.concurrent.atomic.AtomicLong;
import kieker.analysis.display.PlainText;
import kieker.analysis.display.XYPlot;
import kieker.analysis.display.annotation.Display;
import teetime.framework.AbstractConsumerStage;
import teetime.framework.OutputPort;

public final class CountingFilter
extends AbstractConsumerStage<Object> {
    private final OutputPort<Object> relayedEventsOutputPort = this.createOutputPort();
    private final OutputPort<Long> countOutputPort = this.createOutputPort();
    private final AtomicLong counter = new AtomicLong();
    private volatile long timeStampOfInitialization;
    private final PlainText plainText = new PlainText();
    private final XYPlot xyPlot = new XYPlot(50);

    public CountingFilter() {
        this.timeStampOfInitialization = System.currentTimeMillis();
    }

    public final long getMessageCount() {
        return this.counter.get();
    }

    protected void execute(Object event) {
        Long count = this.counter.incrementAndGet();
        this.updateDisplays();
        this.relayedEventsOutputPort.send(event);
        this.countOutputPort.send((Object)count);
    }

    private void updateDisplays() {
        long timeStampDeltaInSeconds = (System.currentTimeMillis() - this.timeStampOfInitialization) / 1000L;
        this.xyPlot.setEntry("", timeStampDeltaInSeconds, this.counter.get());
        this.plainText.setText(Long.toString(this.counter.get()));
    }

    @Display(name="Counter Display")
    public final PlainText plainTextDisplay() {
        return this.plainText;
    }

    @Display(name="XYPlot Counter Display")
    public final XYPlot xyPlotDisplay() {
        return this.xyPlot;
    }
}

