/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.plugin.filter.record;

import kieker.common.record.IMonitoringRecord;
import teetime.framework.AbstractConsumerStage;
import teetime.framework.OutputPort;

public class MonitoringThroughputFilter
extends AbstractConsumerStage<IMonitoringRecord> {
    private final long intervalSize;
    private long currentInterval = -1L;
    private long recordsInInterval;
    private final OutputPort<IMonitoringRecord> uncountedRecordsOutputPort = this.createOutputPort();
    private final OutputPort<Long> throughputOutputPort = this.createOutputPort();
    private final OutputPort<IMonitoringRecord> relayedRecordsOutputPort = this.createOutputPort();

    public MonitoringThroughputFilter(long intervalSize) {
        this.intervalSize = intervalSize;
    }

    protected void execute(IMonitoringRecord record) {
        long timestamp = record.getLoggingTimestamp();
        long interval = timestamp / this.intervalSize;
        if (interval < this.currentInterval) {
            this.uncountedRecordsOutputPort.send((Object)record);
        } else {
            if (interval > this.currentInterval) {
                if (this.currentInterval != -1L) {
                    this.throughputOutputPort.send((Object)this.recordsInInterval);
                    for (long i = this.currentInterval + 1L; i < interval; ++i) {
                        this.throughputOutputPort.send((Object)0L);
                    }
                }
                this.currentInterval = interval;
                this.recordsInInterval = 0L;
            }
            ++this.recordsInInterval;
        }
        this.relayedRecordsOutputPort.send((Object)record);
    }

    public OutputPort<IMonitoringRecord> getUncountedRecordsOutputPort() {
        return this.uncountedRecordsOutputPort;
    }

    public OutputPort<Long> getThroughputOutputPort() {
        return this.throughputOutputPort;
    }

    public OutputPort<IMonitoringRecord> getRelayedRecordsOutputPort() {
        return this.relayedRecordsOutputPort;
    }
}

