/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.plugin.reader.filesystem.format.text.file;

import java.io.File;
import java.nio.CharBuffer;
import kieker.analysisteetime.plugin.reader.filesystem.className.ClassNameRegistryRepository;
import kieker.analysisteetime.plugin.reader.filesystem.util.MappingException;
import kieker.common.exception.IllegalRecordFormatException;
import kieker.common.exception.MonitoringRecordException;
import kieker.common.exception.UnknownRecordTypeException;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.factory.CachedRecordFactoryCatalog;
import kieker.common.record.factory.IRecordFactory;
import kieker.common.record.io.TextValueDeserializer;
import kieker.common.registry.reader.ReaderRegistry;

@Deprecated
public class RecordFromTextLineCreator {
    private static final IllegalRecordFormatException ILLEGAL_RECORD_FORMAT_EXCEPTION = new IllegalRecordFormatException();
    private final CachedRecordFactoryCatalog recordFactories = CachedRecordFactoryCatalog.getInstance();
    private final ClassNameRegistryRepository classNameRegistryRepository;
    private final CharBuffer charBuffer;

    public RecordFromTextLineCreator(ClassNameRegistryRepository classNameRegistryRepository) {
        this.classNameRegistryRepository = classNameRegistryRepository;
        this.charBuffer = CharBuffer.allocate(100000);
    }

    public IMonitoringRecord createRecordFromLine(File textFile, String line) throws MonitoringRecordException, IllegalRecordFormatException, MappingException, UnknownRecordTypeException {
        this.charBuffer.put(line);
        return this.createRecord(this.classNameRegistryRepository.get(textFile.getParentFile()));
    }

    private IMonitoringRecord createRecord(ReaderRegistry<String> readerRegistry) throws MappingException, MonitoringRecordException, UnknownRecordTypeException, IllegalRecordFormatException {
        this.charBuffer.flip();
        char lead = this.charBuffer.get();
        if (lead == '$') {
            TextValueDeserializer deserializer = TextValueDeserializer.create(this.charBuffer);
            int id = deserializer.getInt();
            String classname = readerRegistry.get(id);
            if (classname == null) {
                throw new MappingException("Missing classname mapping for record type id '" + id + "'");
            }
            long loggingTimestamp = deserializer.getLong();
            IRecordFactory<? extends IMonitoringRecord> recordFactory = this.recordFactories.get(classname);
            IMonitoringRecord event = recordFactory.create(deserializer);
            event.setLoggingTimestamp(loggingTimestamp);
            this.charBuffer.clear();
            return event;
        }
        throw ILLEGAL_RECORD_FORMAT_EXCEPTION;
    }
}

