/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.plugin.reader.namedRecordPipe;

import java.util.concurrent.CountDownLatch;
import kieker.common.namedRecordPipe.Broker;
import kieker.common.namedRecordPipe.IPipeReader;
import kieker.common.namedRecordPipe.Pipe;
import kieker.common.record.IMonitoringRecord;
import teetime.framework.AbstractProducerStage;

public class PipeReader
extends AbstractProducerStage<IMonitoringRecord>
implements IPipeReader {
    private volatile Pipe pipe;
    private final CountDownLatch terminationLatch = new CountDownLatch(1);

    public PipeReader(String pipeName) {
        this.pipe = Broker.INSTANCE.acquirePipe(pipeName);
        if (this.pipe == null) {
            throw new IllegalArgumentException("Failed to get Pipe with name " + pipeName);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Connected to named pipe '" + this.pipe.getName() + "'");
        }
        this.pipe.setPipeReader(this);
    }

    protected void execute() {
        try {
            this.terminationLatch.await();
            this.logger.info("Pipe closed. Will terminate.");
        }
        catch (InterruptedException ex) {
            this.logger.error("Received InterruptedException", ex);
        }
    }

    @Override
    public boolean newMonitoringRecord(IMonitoringRecord rec) {
        this.outputPort.send((Object)rec);
        return true;
    }

    @Override
    public void notifyPipeClosed() {
        this.terminationLatch.countDown();
    }

    public void terminateStage() {
        if (this.pipe != null) {
            this.pipe.close();
        }
        super.terminateStage();
    }
}

