/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.plugin.reader.tcp.dualsocket;

import java.nio.ByteBuffer;
import kieker.analysisteetime.plugin.reader.IRecordReceivedListener;
import kieker.analysisteetime.plugin.reader.RecordDeserializer;
import kieker.common.record.IMonitoringRecord;
import kieker.common.registry.reader.ReaderRegistry;
import org.slf4j.Logger;
import teetime.framework.OutputPort;
import teetime.util.stage.io.network.AbstractTcpReader;

class DualSocketTcpLogic
extends AbstractTcpReader
implements IRecordReceivedListener {
    private final OutputPort<IMonitoringRecord> outputPort;
    private final RecordDeserializer recordDeserializer;

    public DualSocketTcpLogic(int port, int bufferCapacity, Logger logger, ReaderRegistry<String> stringRegistry, OutputPort<IMonitoringRecord> outputPort) {
        super(port, bufferCapacity, logger);
        this.outputPort = outputPort;
        this.recordDeserializer = new RecordDeserializer(this, stringRegistry);
    }

    protected boolean onBufferReceived(ByteBuffer buffer) {
        if (buffer.remaining() < 4) {
            return false;
        }
        int clazzId = buffer.getInt();
        return this.recordDeserializer.deserializeRecord(clazzId, buffer);
    }

    @Override
    public void onRecordReceived(IMonitoringRecord record) {
        this.outputPort.send((Object)record);
    }
}

