/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.plugin.reader.tcp.singlesocket;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kieker.analysisteetime.plugin.reader.IRecordReceivedListener;
import kieker.analysisteetime.plugin.reader.RecordDeserializer;
import kieker.common.registry.reader.ReaderRegistry;
import org.slf4j.Logger;
import teetime.util.io.network.AbstractTcpReader;

class SingleSocketTcpLogic
extends AbstractTcpReader {
    private static final int INT_BYTES = 4;
    private static final Charset ENCODING = StandardCharsets.UTF_8;
    private final ReaderRegistry<String> readerRegistry = new ReaderRegistry();
    private final RecordDeserializer recordDeserializer;

    public SingleSocketTcpLogic(int port, int bufferCapacity, Logger logger, IRecordReceivedListener listener) {
        super(port, bufferCapacity, logger);
        this.recordDeserializer = new RecordDeserializer(listener, this.readerRegistry);
    }

    protected boolean onBufferReceived(ByteBuffer buffer) {
        if (buffer.remaining() < 4) {
            return false;
        }
        int clazzId = buffer.getInt();
        if (clazzId == -1) {
            return this.registerRegistryEntry(buffer);
        }
        return this.recordDeserializer.deserializeRecord(clazzId, buffer);
    }

    private boolean registerRegistryEntry(ByteBuffer buffer) {
        if (buffer.remaining() < 8) {
            return false;
        }
        int stringLength = buffer.getInt();
        if (buffer.remaining() < stringLength) {
            return false;
        }
        int id = buffer.getInt();
        byte[] strBytes = new byte[stringLength];
        buffer.get(strBytes);
        String string = new String(strBytes, ENCODING);
        this.readerRegistry.register(id, string);
        return true;
    }
}

