/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.statistics;

import java.util.function.Function;
import kieker.analysisteetime.statistics.IUnit;
import kieker.analysisteetime.statistics.StatisticsDecoratorStage;
import kieker.analysisteetime.statistics.StatisticsModel;
import kieker.analysisteetime.statistics.calculating.AverageCalculator;
import kieker.analysisteetime.statistics.calculating.CountCalculator;
import kieker.analysisteetime.statistics.calculating.MaxCalculator;
import kieker.analysisteetime.statistics.calculating.MedianCalculator;
import kieker.analysisteetime.statistics.calculating.MinCalculator;
import kieker.analysisteetime.statistics.calculating.TotalCalculator;
import teetime.framework.CompositeStage;
import teetime.framework.InputPort;
import teetime.framework.OutputPort;

public class FullStatisticsDecoratorStage<T>
extends CompositeStage {
    private final StatisticsDecoratorStage<T> countStatistics;
    private final StatisticsDecoratorStage<T> medianStatistics;

    public FullStatisticsDecoratorStage(StatisticsModel statisticsModel, IUnit unit, Function<T, Long> valueAccessor, Function<T, Object> objectAccesor) {
        this.countStatistics = new StatisticsDecoratorStage(statisticsModel, unit, new CountCalculator(), objectAccesor);
        StatisticsDecoratorStage<T> totalStatistics = new StatisticsDecoratorStage<T>(statisticsModel, unit, new TotalCalculator<T>(valueAccessor), objectAccesor);
        StatisticsDecoratorStage<T> minStatistics = new StatisticsDecoratorStage<T>(statisticsModel, unit, new MinCalculator<T>(valueAccessor), objectAccesor);
        StatisticsDecoratorStage<T> maxStatistics = new StatisticsDecoratorStage<T>(statisticsModel, unit, new MaxCalculator<T>(valueAccessor), objectAccesor);
        StatisticsDecoratorStage averageStatistics = new StatisticsDecoratorStage(statisticsModel, unit, new AverageCalculator(), objectAccesor);
        this.medianStatistics = new StatisticsDecoratorStage<T>(statisticsModel, unit, new MedianCalculator<T>(valueAccessor), objectAccesor);
        super.connectPorts(this.countStatistics.getOutputPort(), totalStatistics.getInputPort());
        super.connectPorts(totalStatistics.getOutputPort(), minStatistics.getInputPort());
        super.connectPorts(minStatistics.getOutputPort(), maxStatistics.getInputPort());
        super.connectPorts(maxStatistics.getOutputPort(), averageStatistics.getInputPort());
        super.connectPorts(averageStatistics.getOutputPort(), this.medianStatistics.getInputPort());
    }

    public InputPort<T> getInputPort() {
        return this.countStatistics.getInputPort();
    }

    public OutputPort<T> getOutputPort() {
        return this.medianStatistics.getOutputPort();
    }
}

