/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.statistics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kieker.analysisteetime.statistics.IUnit;
import kieker.analysisteetime.statistics.Statistic;

public class Statistics {
    private static final int DEFAULT_INITIAL_CAPACITY = 4;
    private final Map<IUnit, Statistic> statistics = new HashMap<IUnit, Statistic>(4);

    public Statistic getStatistic(IUnit unit) {
        Objects.requireNonNull(unit, "Unit must not be null");
        return this.statistics.computeIfAbsent(unit, x -> new Statistic());
    }

    public boolean hasStatistic(IUnit unit) {
        Objects.requireNonNull(unit, "Unit must not be null");
        return this.statistics.containsKey(unit);
    }

    public Set<IUnit> getUnits() {
        return Collections.unmodifiableSet(this.statistics.keySet());
    }
}

