/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.statistics;

import java.util.function.Function;
import kieker.analysisteetime.statistics.IUnit;
import kieker.analysisteetime.statistics.Statistic;
import kieker.analysisteetime.statistics.StatisticsModel;
import kieker.analysisteetime.statistics.calculating.ICalculator;

public class StatisticsDecorator<T> {
    private final StatisticsModel statisticsModel;
    private final IUnit unit;
    private final ICalculator<T> statisticCalculator;
    private final Function<T, Object> objectAccesor;

    public StatisticsDecorator(StatisticsModel statisticsModel, IUnit unit, ICalculator<T> statisticCalculator, Function<T, Object> objectAccesor) {
        this.statisticsModel = statisticsModel;
        this.unit = unit;
        this.statisticCalculator = statisticCalculator;
        this.objectAccesor = objectAccesor;
    }

    public void decorate(T input) {
        Object object = this.objectAccesor.apply(input);
        Statistic statistic = this.statisticsModel.get(object).getStatistic(this.unit);
        this.statisticCalculator.calculate(statistic, input, object);
    }
}

