/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.statistics.calculating;

import java.util.Optional;
import java.util.function.Function;
import kieker.analysisteetime.statistics.IProperty;
import kieker.analysisteetime.statistics.Properties;
import kieker.analysisteetime.statistics.Statistic;
import kieker.analysisteetime.statistics.calculating.ICalculator;

public class MaxCalculator<T>
implements ICalculator<T> {
    private static final IProperty MAX_PROPERTY = Properties.MAX;
    private final Function<T, Long> valueAccessor;

    public MaxCalculator(Function<T, Long> valueAccessor) {
        this.valueAccessor = valueAccessor;
    }

    @Override
    public void calculate(Statistic statistic, T input, Object modelObject) {
        long value = this.valueAccessor.apply(input);
        Optional<Long> oldMax = Optional.ofNullable(statistic.getProperty(MAX_PROPERTY));
        if (!oldMax.isPresent() || value > oldMax.get()) {
            statistic.setProperty(MAX_PROPERTY, value);
        }
    }
}

