/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.statistics.calculating;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import kieker.analysisteetime.statistics.IProperty;
import kieker.analysisteetime.statistics.Properties;
import kieker.analysisteetime.statistics.Statistic;
import kieker.analysisteetime.statistics.calculating.ICalculator;
import kieker.analysisteetime.util.RunningMedian;

public class MedianCalculator<T>
implements ICalculator<T> {
    private static final IProperty MEDIAN_PROPERTY = Properties.MEDIAN;
    private final Map<Object, RunningMedian<Long>> runningMedians = new HashMap<Object, RunningMedian<Long>>();
    private final Function<T, Long> valueAccessor;

    public MedianCalculator(Function<T, Long> valueAccessor) {
        this.valueAccessor = valueAccessor;
    }

    @Override
    public void calculate(Statistic statistic, T input, Object modelObject) {
        RunningMedian runningMedian = this.runningMedians.computeIfAbsent(modelObject, o -> RunningMedian.forLong());
        runningMedian.add((Comparable)this.valueAccessor.apply(input));
        long newMedian = (Long)runningMedian.getMedian();
        statistic.setProperty(MEDIAN_PROPERTY, newMedian);
    }
}

