/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.statistics.calculating;

import java.util.Optional;
import java.util.function.Function;
import kieker.analysisteetime.statistics.IProperty;
import kieker.analysisteetime.statistics.Properties;
import kieker.analysisteetime.statistics.Statistic;
import kieker.analysisteetime.statistics.calculating.ICalculator;

public class MinCalculator<T>
implements ICalculator<T> {
    private static final IProperty MIN_PROPERTY = Properties.MIN;
    private final Function<T, Long> valueAccessor;

    public MinCalculator(Function<T, Long> valueAccessor) {
        this.valueAccessor = valueAccessor;
    }

    @Override
    public void calculate(Statistic statistic, T input, Object modelObject) {
        long value = this.valueAccessor.apply(input);
        Optional<Long> oldMin = Optional.ofNullable(statistic.getProperty(MIN_PROPERTY));
        if (!oldMin.isPresent() || value < oldMin.get()) {
            statistic.setProperty(MIN_PROPERTY, value);
        }
    }
}

