/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.statistics.calculating;

import java.util.function.Function;
import kieker.analysisteetime.statistics.IProperty;
import kieker.analysisteetime.statistics.Properties;
import kieker.analysisteetime.statistics.Statistic;
import kieker.analysisteetime.statistics.calculating.ICalculator;

public class TotalCalculator<T>
implements ICalculator<T> {
    private static final IProperty TOTAL_PROPERTY = Properties.TOTAL;
    private final Function<T, Long> valueAccessor;

    public TotalCalculator(Function<T, Long> valueAccessor) {
        this.valueAccessor = valueAccessor;
    }

    @Override
    public void calculate(Statistic statistic, T input, Object modelObject) {
        long value = this.valueAccessor.apply(input);
        Long oldCount = statistic.getProperty(TOTAL_PROPERTY);
        if (oldCount == null) {
            statistic.setProperty(TOTAL_PROPERTY, value);
        } else {
            long newCount = oldCount + value;
            statistic.setProperty(TOTAL_PROPERTY, newCount);
        }
    }
}

