/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.trace.graph;

import kieker.analysisteetime.model.analysismodel.deployment.DeploymentContext;
import kieker.analysisteetime.model.analysismodel.trace.OperationCall;
import kieker.analysisteetime.model.analysismodel.type.ComponentType;
import kieker.analysisteetime.model.analysismodel.type.OperationType;
import kieker.analysisteetime.trace.traversal.IOperationCallVisitor;
import kieker.analysisteetime.util.ObjectIdentifierRegistry;
import kieker.analysisteetime.util.graph.IEdge;
import kieker.analysisteetime.util.graph.IGraph;
import kieker.analysisteetime.util.graph.IVertex;

public class GraphTransformerVisitor
implements IOperationCallVisitor {
    private final IGraph graph;
    private final ObjectIdentifierRegistry objectIdentifierRegistry = new ObjectIdentifierRegistry();

    public GraphTransformerVisitor(IGraph graph) {
        this.graph = graph;
    }

    @Override
    public void visit(OperationCall operationCall) {
        this.addVertex(operationCall);
        if (operationCall.getParent() != null) {
            this.addEdge(operationCall);
        } else {
            this.addRootVertex(operationCall);
        }
    }

    private IVertex addVertex(OperationCall operationCall) {
        int vertexId = this.objectIdentifierRegistry.getIdentifier(operationCall);
        IVertex vertex = this.graph.addVertex(vertexId);
        OperationType operationType = operationCall.getOperation().getAssemblyOperation().getOperationType();
        ComponentType componentType = operationType.getComponentType();
        DeploymentContext deploymentContext = operationCall.getOperation().getComponent().getDeploymentContext();
        vertex.setProperty("name", operationType.getName());
        vertex.setProperty("returnType", operationType.getReturnType());
        vertex.setProperty("modifiers", operationType.getModifiers());
        vertex.setProperty("parameterTypes", operationType.getParameterTypes());
        vertex.setProperty("component", componentType.getName());
        vertex.setProperty("package", componentType.getPackage());
        vertex.setProperty("deploymentContext", deploymentContext.getName());
        vertex.setProperty("stackDepth", operationCall.getStackDepth());
        return vertex;
    }

    private IEdge addEdge(OperationCall operationCall) {
        int thisVertexId = this.objectIdentifierRegistry.getIdentifier(operationCall);
        IVertex thisVertex = this.graph.getVertex(thisVertexId);
        int parentVertexId = this.objectIdentifierRegistry.getIdentifier(operationCall.getParent());
        IVertex parentVertex = this.graph.getVertex(parentVertexId);
        if (thisVertex == null) {
            throw new IllegalStateException("Target vertex not found (operationCall:" + operationCall + ").");
        }
        if (parentVertex == null) {
            throw new IllegalStateException("Source vertex not found (operationCall:" + operationCall.getParent() + ").");
        }
        IEdge edge = this.graph.addEdge(null, parentVertex, thisVertex);
        edge.setProperty("orderIndex", operationCall.getOrderIndex() + 1);
        return edge;
    }

    private IVertex addRootVertex(OperationCall rootOperationCall) {
        int rootVertexId = this.objectIdentifierRegistry.getIdentifier(rootOperationCall);
        IVertex rootVertex = this.graph.getVertex(rootVertexId);
        if (rootVertex == null) {
            throw new IllegalStateException("Root vertex not found (operationCall:" + rootOperationCall + ").");
        }
        IVertex entryVertex = this.graph.addVertex("'Entry'");
        entryVertex.setProperty("artificial", true);
        entryVertex.setProperty("name", "'Entry'");
        IEdge edge = this.graph.addEdge(null, entryVertex, rootVertex);
        edge.setProperty("orderIndex", 1);
        return entryVertex;
    }
}

