/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.trace.graph.dot;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import kieker.analysisteetime.util.graph.IVertex;

public class NodeLabelMapper
implements Function<IVertex, String> {
    @Override
    public String apply(IVertex vertex) {
        Collection castedParameters;
        Collection castedModifiers;
        if (vertex.getProperty("artificial") != null) {
            return vertex.getProperty("name").toString();
        }
        if (!(vertex.getProperty("modifiers") instanceof Collection)) {
            throw new IllegalArgumentException("Vertex property 'modifiers' is not a collection.");
        }
        Collection modifiers = castedModifiers = (Collection)vertex.getProperty("modifiers");
        if (!(vertex.getProperty("parameterTypes") instanceof Collection)) {
            throw new IllegalArgumentException("Vertex property 'parameterTypes' is not a collection.");
        }
        Collection parameters = castedParameters = (Collection)vertex.getProperty("parameterTypes");
        StringBuilder signature = new StringBuilder();
        signature.append(modifiers.stream().collect(Collectors.joining(" "))).append(' ').append(vertex.getProperty("returnType").toString()).append(' ').append(vertex.getProperty("name").toString()).append('(').append(parameters.stream().collect(Collectors.joining(", "))).append(')');
        StringBuilder label = new StringBuilder().append(vertex.getProperty("deploymentContext").toString()).append("::\\n").append('@').append(vertex.getProperty("stackDepth").toString()).append(':').append(vertex.getProperty("component").toString()).append("\\n").append((CharSequence)signature);
        return label.toString();
    }
}

