/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.trace.reconstruction;

import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kieker.analysisteetime.model.analysismodel.deployment.DeploymentModel;
import kieker.analysisteetime.model.analysismodel.trace.Trace;
import kieker.analysisteetime.trace.reconstruction.TraceReconstructionBuffer;
import kieker.common.record.flow.trace.TraceMetadata;
import kieker.common.record.flow.trace.operation.AfterOperationEvent;
import kieker.common.record.flow.trace.operation.BeforeOperationEvent;

final class TraceReconstructor {
    private final DeploymentModel deploymentModel;
    private final Map<Long, TraceReconstructionBuffer> traceBuffers = new HashMap<Long, TraceReconstructionBuffer>();
    private final List<TraceReconstructionBuffer> faultyTraceBuffers = new ArrayList<TraceReconstructionBuffer>();
    private int danglingRecords;
    private final TemporalUnit temporalUnit;

    public TraceReconstructor(DeploymentModel deploymentRoot, TemporalUnit temporalUnit) {
        this.deploymentModel = deploymentRoot;
        this.temporalUnit = temporalUnit;
    }

    public int countIncompleteTraces() {
        return this.traceBuffers.size() + this.faultyTraceBuffers.size();
    }

    public int countDanglingRecords() {
        return this.danglingRecords - this.faultyTraceBuffers.size();
    }

    public void handleTraceMetadataRecord(TraceMetadata record) {
        long traceID = record.getTraceId();
        TraceReconstructionBuffer newTraceBuffer = new TraceReconstructionBuffer(this.deploymentModel, record, this.temporalUnit);
        this.traceBuffers.put(traceID, newTraceBuffer);
    }

    public void handleBeforeOperationEventRecord(BeforeOperationEvent event) {
        long traceID = event.getTraceId();
        TraceReconstructionBuffer traceBuffer = this.traceBuffers.get(traceID);
        if (traceBuffer != null) {
            traceBuffer.handleBeforeOperationEventRecord(event);
        } else {
            ++this.danglingRecords;
        }
    }

    public Optional<Trace> handleAfterOperationEventRecord(AfterOperationEvent event) {
        long traceID = event.getTraceId();
        TraceReconstructionBuffer traceBuffer = this.traceBuffers.get(traceID);
        if (traceBuffer != null) {
            traceBuffer.handleAfterOperationEventRecord(event);
            if (traceBuffer.isTraceComplete()) {
                Trace trace = traceBuffer.reconstructTrace();
                this.traceBuffers.remove(traceID);
                return Optional.of(trace);
            }
        } else {
            ++this.danglingRecords;
        }
        return Optional.empty();
    }
}

