/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.trace.traversal;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import kieker.analysisteetime.model.analysismodel.trace.OperationCall;
import kieker.analysisteetime.model.analysismodel.trace.Trace;
import kieker.analysisteetime.trace.traversal.IOperationCallVisitor;

public class TraceTraverser {
    public void traverse(Trace trace, IOperationCallVisitor visitor) {
        Set<IOperationCallVisitor> visitors = Collections.singleton(visitor);
        this.handleOperationCallsRecursively(trace.getRootOperationCall(), visitors);
    }

    public void traverse(Trace trace, Collection<IOperationCallVisitor> visitors) {
        this.handleOperationCallsRecursively(trace.getRootOperationCall(), visitors);
    }

    private void handleOperationCallsRecursively(OperationCall operationCall, Collection<IOperationCallVisitor> visitors) {
        for (IOperationCallVisitor visitor : visitors) {
            visitor.visit(operationCall);
        }
        for (OperationCall childOperationCall : operationCall.getChildren()) {
            this.handleOperationCallsRecursively(childOperationCall, visitors);
        }
    }
}

