/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.util.emf;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import kieker.analysisteetime.util.emf.AbstractEReferenceChangedListener;
import kieker.analysisteetime.util.emf.AbstractEStructuralFeatureChangedListener;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class EReferenceIndex<K, V extends EObject> {
    protected final BiMap<K, V> index;
    protected final EReference reference;
    protected final Collection<EStructuralFeature> observedReferenceAttributes;
    protected final Function<V, K> keyCreator;

    private EReferenceIndex(EObject object, EReference reference, Collection<EStructuralFeature> observedReferenceAttributes, Function<V, K> keyCreator, Collection<V> values) {
        this.reference = reference;
        this.observedReferenceAttributes = observedReferenceAttributes;
        this.keyCreator = keyCreator;
        this.index = values == null || values.isEmpty() ? HashBiMap.create() : (BiMap)values.stream().collect(Collectors.toMap(this.keyCreator, Function.identity(), (a, b) -> b, HashBiMap::create));
        ChangedListener changedListener = new ChangedListener();
        object.eAdapters().add((Object)changedListener);
    }

    public boolean contains(K key) {
        return this.index.containsKey(key);
    }

    public V get(K key) {
        return (V)((EObject)this.index.get(key));
    }

    public static <K, V extends EObject> EReferenceIndex<K, V> createEmpty(EObject object, EReference reference, Collection<EStructuralFeature> observedReferenceAttributes, Function<V, K> keyCreator) {
        return new EReferenceIndex<K, V>(object, reference, observedReferenceAttributes, keyCreator, null);
    }

    public static <K, V extends EObject> EReferenceIndex<K, V> create(EObject object, EReference reference, Collection<EStructuralFeature> observedReferenceAttributes, Function<V, K> keyCreator) {
        EList values = (EList)object.eGet((EStructuralFeature)reference);
        return new EReferenceIndex<K, V>(object, reference, observedReferenceAttributes, keyCreator, values);
    }

    public static <K, V extends EObject> EReferenceIndex<K, V> create(EObject object, EReference reference, Collection<EStructuralFeature> observedReferenceAttributes, Function<V, K> keyCreator, Collection<V> values) {
        return new EReferenceIndex<K, V>(object, reference, observedReferenceAttributes, keyCreator, values);
    }

    private class ElementChangedListener
    extends AbstractEStructuralFeatureChangedListener<V> {
        public ElementChangedListener() {
            super(EReferenceIndex.this.observedReferenceAttributes);
        }

        @Override
        protected void notifyChanged(V object) {
            Object key = EReferenceIndex.this.keyCreator.apply(object);
            EReferenceIndex.this.index.forcePut(key, object);
        }
    }

    private class ChangedListener
    extends AbstractEReferenceChangedListener<V> {
        private final ElementChangedListener elementChangedListener;

        public ChangedListener() {
            super(EReferenceIndex.this.reference);
            this.elementChangedListener = new ElementChangedListener();
        }

        @Override
        protected void notifyElementAdded(V element) {
            Object key = EReferenceIndex.this.keyCreator.apply(element);
            EReferenceIndex.this.index.forcePut(key, element);
            element.eAdapters().add((Object)this.elementChangedListener);
        }

        @Override
        protected void notifyElementRemoved(V element) {
            Object key = EReferenceIndex.this.keyCreator.apply(element);
            EReferenceIndex.this.index.remove(key);
            element.eAdapters().remove((Object)this.elementChangedListener);
        }
    }
}

