/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.util.graph.export.blueprints;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.tg.TinkerGraph;
import java.util.HashMap;
import java.util.Map;
import kieker.analysisteetime.util.graph.Direction;
import kieker.analysisteetime.util.graph.IEdge;
import kieker.analysisteetime.util.graph.IGraph;
import kieker.analysisteetime.util.graph.IVertex;
import kieker.analysisteetime.util.graph.export.AbstractTransformer;

public class BlueprintsTransformer
extends AbstractTransformer<Graph> {
    private static final String LABEL_PROPERTY = "label";
    private final Graph transformedGraph = new TinkerGraph();
    private final Map<IVertex, Vertex> mappedVertices = new HashMap<IVertex, Vertex>();

    public BlueprintsTransformer(IGraph graph) {
        super(graph);
    }

    @Override
    protected void transformVertex(IVertex vertex) {
        Vertex mappedVertex = this.transformedGraph.addVertex(vertex.getId());
        this.mappedVertices.put(vertex, mappedVertex);
        for (String propertyKey : vertex.getPropertyKeys()) {
            mappedVertex.setProperty(propertyKey, vertex.getProperty(propertyKey));
        }
    }

    @Override
    protected void transformEdge(IEdge edge) {
        Vertex mappedInVertex = this.mappedVertices.get(edge.getVertex(Direction.IN));
        Vertex mappedOutVertex = this.mappedVertices.get(edge.getVertex(Direction.OUT));
        String label = (String)edge.getProperty(LABEL_PROPERTY);
        if (label == null) {
            label = "";
        }
        Edge mappedEdge = this.transformedGraph.addEdge(edge.getId(), mappedOutVertex, mappedInVertex, label);
        for (String propertyKey : edge.getPropertyKeys()) {
            mappedEdge.setProperty(propertyKey, edge.getProperty(propertyKey));
        }
    }

    @Override
    protected Graph getTransformation() {
        return this.transformedGraph;
    }

    @Override
    protected void beforeTransformation() {
    }

    @Override
    protected void afterTransformation() {
    }
}

