/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.util.graph.export.dot;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import kieker.analysisteetime.util.graph.IGraph;
import kieker.analysisteetime.util.graph.export.dot.DotElementExporter;
import kieker.analysisteetime.util.graph.export.dot.DotExportConfiguration;
import kieker.analysisteetime.util.graph.export.dot.SimpleDotExportConfiguration;
import kieker.analysisteetime.util.graph.util.dot.DotGraphWriter;
import kieker.analysisteetime.util.graph.util.dot.attributes.DotEdgeAttribute;
import kieker.analysisteetime.util.graph.util.dot.attributes.DotGraphAttribute;
import kieker.analysisteetime.util.graph.util.dot.attributes.DotNodeAttribute;

public class DotExporter
extends DotElementExporter {
    public DotExporter(IGraph graph, Writer writer) {
        this(graph, writer, (DotExportConfiguration)new SimpleDotExportConfiguration());
    }

    public DotExporter(IGraph graph, Writer writer, DotExportConfiguration configuration) {
        super(graph, new DotGraphWriter(writer), configuration);
    }

    @Override
    protected void beforeTransformation() {
        try {
            this.dotGraphWriter.start(this.graph.getName());
            for (Map.Entry<DotGraphAttribute, Function<IGraph, String>> entry : this.configuration.getGraphAttributes()) {
                this.dotGraphWriter.addGraphAttribute(entry.getKey().toString(), entry.getValue().apply(this.graph));
            }
            HashMap<String, String> defaultNodeAttributes = new HashMap<String, String>();
            for (Map.Entry<DotNodeAttribute, Function<IGraph, String>> entry : this.configuration.getDefaultNodeAttributes()) {
                defaultNodeAttributes.put(entry.getKey().toString(), entry.getValue().apply(this.graph));
            }
            this.dotGraphWriter.addDefaultNodeAttributes(defaultNodeAttributes);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Map.Entry<DotEdgeAttribute, Function<IGraph, String>> attribute : this.configuration.getDefaultEdgeAttributes()) {
                hashMap.put(attribute.getKey().toString(), attribute.getValue().apply(this.graph));
            }
            this.dotGraphWriter.addDefaultEdgeAttributes(hashMap);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    protected void afterTransformation() {
        try {
            this.dotGraphWriter.finish();
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }
}

