/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.util.graph.export.dot;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import kieker.analysisteetime.util.graph.IGraph;
import kieker.analysisteetime.util.graph.export.dot.DotExportConfiguration;
import kieker.analysisteetime.util.graph.export.dot.DotWriterStage;
import kieker.analysisteetime.util.graph.export.dot.SimpleDotExportConfiguration;
import kieker.analysisteetime.util.graph.mapping.SimpleFileNameMapper;
import kieker.analysisteetime.util.graph.util.FileExtension;

public class DotFileWriterStage
extends DotWriterStage {
    public DotFileWriterStage(Function<IGraph, String> fileNameMapper) {
        this(fileNameMapper, (DotExportConfiguration)new SimpleDotExportConfiguration());
    }

    public DotFileWriterStage(Function<IGraph, String> fileNameMapper, DotExportConfiguration exportConfiguration) {
        super(fileNameMapper.andThen(fileName -> {
            try {
                return new OutputStreamWriter((OutputStream)new FileOutputStream((String)fileName), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }), exportConfiguration);
    }

    public DotFileWriterStage(String outputDirectory) {
        this(outputDirectory, (DotExportConfiguration)new SimpleDotExportConfiguration());
    }

    public DotFileWriterStage(String outputDirectory, DotExportConfiguration exportConfiguration) {
        this(new SimpleFileNameMapper(outputDirectory, FileExtension.DOT), exportConfiguration);
    }
}

