/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.util.graph.impl;

final class ExceptionFactory {
    private ExceptionFactory() {
    }

    public static IllegalArgumentException vertexIdCanNotBeNull() {
        return new IllegalArgumentException("Vertex id can not be null");
    }

    public static IllegalArgumentException edgeIdCanNotBeNull() {
        return new IllegalArgumentException("Edge id can not be null");
    }

    public static IllegalArgumentException vertexWithIdAlreadyExists(Object id) {
        return new IllegalArgumentException("Vertex with id already exists: " + id);
    }

    public static IllegalArgumentException edgeWithIdAlreadyExists(Object id) {
        return new IllegalArgumentException("Edge with id already exists: " + id);
    }

    public static IllegalStateException vertexWithIdDoesNotExist(Object id) {
        return new IllegalStateException("Vertex with id does not exist: " + id);
    }

    public static IllegalStateException edgeWithIdDoesNotExist(Object id) {
        return new IllegalStateException("Edge with id does not exist: " + id);
    }

    public static IllegalStateException verticesAreNotInSameGraph(Object id1, Object id2) {
        return new IllegalStateException("Vertices with ids are not in the same graph: " + id1 + ", " + id2);
    }

    public static IllegalArgumentException bothIsNotSupported() {
        return new IllegalArgumentException("A direction of BOTH is not supported");
    }

    public static IllegalArgumentException propertyKeyIsReserved(String key) {
        return new IllegalArgumentException("Property key is reserved for all elements: " + key);
    }

    public static IllegalArgumentException propertyKeyCanNotBeEmpty() {
        return new IllegalArgumentException("Property key can not be the empty string");
    }

    public static IllegalArgumentException propertyKeyCanNotBeNull() {
        return new IllegalArgumentException("Property key can not be null");
    }

    public static IllegalArgumentException propertyValueCanNotBeNull() {
        return new IllegalArgumentException("Property value can not be null");
    }
}

