/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.util.graph.impl;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import kieker.analysisteetime.util.graph.Direction;
import kieker.analysisteetime.util.graph.IEdge;
import kieker.analysisteetime.util.graph.IGraph;
import kieker.analysisteetime.util.graph.IVertex;
import kieker.analysisteetime.util.graph.impl.EdgeImpl;
import kieker.analysisteetime.util.graph.impl.ElementImpl;
import kieker.analysisteetime.util.graph.impl.ExceptionFactory;
import kieker.analysisteetime.util.graph.impl.VertexImpl;

public class GraphImpl
extends ElementImpl
implements IGraph {
    protected String name = "G";
    protected Map<Object, IVertex> vertices = new HashMap<Object, IVertex>();
    protected Map<Object, IEdge> edges = new HashMap<Object, IEdge>();
    protected long currentDefaultId;
    protected VertexImpl parentVertex;

    protected GraphImpl() {
    }

    protected GraphImpl(VertexImpl parentVertex) {
        this.parentVertex = parentVertex;
    }

    @Override
    public IVertex addVertex(Object id) {
        Object freeId = id;
        if (freeId == null) {
            while (this.vertices.containsKey(freeId = this.getDefaultId())) {
            }
        } else if (this.vertices.containsKey(freeId)) {
            throw ExceptionFactory.vertexWithIdAlreadyExists(freeId);
        }
        VertexImpl vertex = new VertexImpl(freeId, this);
        this.vertices.put(vertex.getId(), vertex);
        return vertex;
    }

    @Override
    public IVertex addVertexIfAbsent(Object id) {
        IVertex vertex = this.getVertex(id);
        if (vertex == null) {
            vertex = this.addVertex(id);
        }
        return vertex;
    }

    @Override
    public IVertex getVertex(Object id) {
        if (id == null) {
            throw ExceptionFactory.vertexIdCanNotBeNull();
        }
        return this.vertices.get(id);
    }

    @Override
    public Iterable<IVertex> getVertices() {
        return Iterables.unmodifiableIterable(this.vertices.values());
    }

    @Override
    public void removeVertex(IVertex vertex) {
        if (!this.vertices.containsKey(vertex.getId())) {
            throw ExceptionFactory.vertexWithIdDoesNotExist(vertex.getId());
        }
        for (IEdge edge : vertex.getEdges(Direction.IN)) {
            this.removeEdge(edge);
        }
        for (IEdge edge : vertex.getEdges(Direction.OUT)) {
            this.removeEdge(edge);
        }
        this.vertices.remove(vertex.getId());
    }

    @Override
    public IEdge addEdge(Object id, IVertex outVertex, IVertex inVertex) {
        Stack<VertexImpl> outVertexParents = new Stack<VertexImpl>();
        VertexImpl parent = (VertexImpl)outVertex;
        while (parent != null) {
            outVertexParents.push(parent);
            parent = parent.graph.parentVertex;
        }
        Stack<VertexImpl> inVertexParents = new Stack<VertexImpl>();
        VertexImpl parent2 = (VertexImpl)inVertex;
        while (parent2 != null) {
            inVertexParents.push(parent2);
            parent2 = parent2.graph.parentVertex;
        }
        if (((VertexImpl)outVertexParents.peek()).graph != ((VertexImpl)inVertexParents.peek()).graph) {
            throw ExceptionFactory.verticesAreNotInSameGraph(outVertex.getId(), inVertex.getId());
        }
        GraphImpl firstEqualParent = null;
        while (!outVertexParents.isEmpty() && !inVertexParents.isEmpty() && ((VertexImpl)outVertexParents.peek()).graph == ((VertexImpl)inVertexParents.pop()).graph) {
            firstEqualParent = ((VertexImpl)outVertexParents.pop()).graph;
        }
        return firstEqualParent.addEdgeChecked(id, outVertex, inVertex);
    }

    @Override
    public IEdge addEdgeIfAbsent(Object id, IVertex outVertex, IVertex inVertex) {
        IEdge edge = this.getEdge(id);
        if (edge == null) {
            edge = this.addEdge(id, outVertex, inVertex);
        }
        return edge;
    }

    protected IEdge addEdgeChecked(Object id, IVertex outVertex, IVertex inVertex) {
        Object freeId = id;
        if (freeId == null) {
            while (this.edges.containsKey(freeId = this.getDefaultId())) {
            }
        } else if (this.edges.containsKey(freeId)) {
            throw ExceptionFactory.edgeWithIdAlreadyExists(freeId);
        }
        EdgeImpl edge = new EdgeImpl(freeId, outVertex, inVertex, this);
        this.edges.put(edge.getId(), edge);
        ((VertexImpl)outVertex).addOutEdge(edge);
        ((VertexImpl)inVertex).addInEdge(edge);
        return edge;
    }

    @Override
    public IEdge getEdge(Object id) {
        if (id == null) {
            throw ExceptionFactory.edgeIdCanNotBeNull();
        }
        return this.edges.get(id);
    }

    @Override
    public Iterable<IEdge> getEdges() {
        return Iterables.unmodifiableIterable(this.edges.values());
    }

    @Override
    public void removeEdge(IEdge edge) {
        if (!this.edges.containsKey(edge.getId())) {
            throw ExceptionFactory.edgeWithIdDoesNotExist(edge.getId());
        }
        ((VertexImpl)edge.getVertex(Direction.IN)).removeInEdge(edge);
        ((VertexImpl)edge.getVertex(Direction.OUT)).removeOutEdge(edge);
        this.edges.remove(edge.getId());
    }

    private Object getDefaultId() {
        long id;
        while (this.vertices.containsKey(id = this.currentDefaultId++) || this.edges.containsKey(id)) {
        }
        return id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (name != null) {
            this.name = name;
        }
    }
}

