/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.util.graph.traversal;

import java.util.ArrayList;
import java.util.List;
import kieker.analysisteetime.util.graph.IGraph;
import kieker.analysisteetime.util.graph.traversal.IEdgeVisitor;
import kieker.analysisteetime.util.graph.traversal.IVertexVisitor;

public abstract class AbstractGraphTraverser {
    protected List<IVertexVisitor> vertexVisitors;
    protected List<IEdgeVisitor> edgeVisitors;

    public AbstractGraphTraverser() {
        this.vertexVisitors = new ArrayList<IVertexVisitor>();
        this.edgeVisitors = new ArrayList<IEdgeVisitor>();
    }

    public AbstractGraphTraverser(IVertexVisitor vertexVisitor, IEdgeVisitor edgeVisitor) {
        this();
        this.vertexVisitors.add(vertexVisitor);
        this.edgeVisitors.add(edgeVisitor);
    }

    public AbstractGraphTraverser(List<IVertexVisitor> vertexVisitors, List<IEdgeVisitor> edgeVisitors) {
        this.vertexVisitors = vertexVisitors;
        this.edgeVisitors = edgeVisitors;
    }

    public List<IVertexVisitor> getVertexVisitors() {
        return this.vertexVisitors;
    }

    public void setVertexVisitors(List<IVertexVisitor> vertexVisitors) {
        this.vertexVisitors = vertexVisitors;
    }

    public void addVertexVisitor(IVertexVisitor vertexVisitor) {
        this.vertexVisitors.add(vertexVisitor);
    }

    public List<IEdgeVisitor> getEdgeVisitors() {
        return this.edgeVisitors;
    }

    public void setEdgeVisitors(List<IEdgeVisitor> edgeVisitors) {
        this.edgeVisitors = edgeVisitors;
    }

    public void addEdgeVisitor(IEdgeVisitor edgeVisitor) {
        this.edgeVisitors.add(edgeVisitor);
    }

    public abstract void traverse(IGraph var1);
}

