/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.util.graph.traversal;

import java.util.List;
import kieker.analysisteetime.util.graph.IEdge;
import kieker.analysisteetime.util.graph.IGraph;
import kieker.analysisteetime.util.graph.IVertex;
import kieker.analysisteetime.util.graph.traversal.AbstractGraphTraverser;
import kieker.analysisteetime.util.graph.traversal.IEdgeVisitor;
import kieker.analysisteetime.util.graph.traversal.IVertexVisitor;

public class DeepGraphTraverser
extends AbstractGraphTraverser {
    public DeepGraphTraverser() {
    }

    public DeepGraphTraverser(List<IVertexVisitor> vertexVisitors, List<IEdgeVisitor> edgeVisitors) {
        super(vertexVisitors, edgeVisitors);
    }

    public DeepGraphTraverser(IVertexVisitor vertexVisitor, IEdgeVisitor edgeVisitor) {
        super(vertexVisitor, edgeVisitor);
    }

    @Override
    public void traverse(IGraph graph) {
        for (IVertex vertex : graph.getVertices()) {
            for (Object visitor : this.vertexVisitors) {
                visitor.visitVertex(vertex);
            }
            if (!vertex.hasChildGraph()) continue;
            this.traverse(vertex.getChildGraph());
        }
        for (IEdge edge : graph.getEdges()) {
            for (Object visitor : this.edgeVisitors) {
                visitor.visitEdge(edge);
            }
        }
    }
}

