/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysisteetime.util.graph.util.dot;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.stream.Collectors;
import kieker.analysisteetime.util.graph.util.IndentWriter;
import kieker.analysisteetime.util.graph.util.dot.DotGraphType;

public class DotGraphWriter {
    private final IndentWriter writer;
    private DotWriterState state = DotWriterState.CREATED;
    private int openSubgraphs;
    private DotGraphType graphType = DotGraphType.DIRECTED;

    public DotGraphWriter(Writer writer) {
        this.writer = new IndentWriter(writer);
    }

    public void start(String name) throws IOException {
        this.start(DotGraphType.DIRECTED, name);
    }

    public void start(DotGraphType newGraphType, String name) throws IOException {
        this.checkState(DotWriterState.CREATED);
        this.graphType = newGraphType;
        String openToken = this.graphType == DotGraphType.UNDIRECTED ? "graph" : "digraph";
        this.writer.writeln(openToken + ' ' + '\"' + name + '\"' + ' ' + "{");
        this.writer.indent();
        this.state = DotWriterState.STARTED;
    }

    public void finish() throws IOException {
        this.checkState(DotWriterState.STARTED);
        if (this.openSubgraphs > 0) {
            throw new IllegalStateException("There are unclosed subgraphs.");
        }
        this.writer.unindent();
        this.writer.writeln("}");
        this.state = DotWriterState.FINISHED;
        this.writer.close();
    }

    public void addDefaultNodeAttributes(Map<String, String> attributes) throws IOException {
        this.checkState(DotWriterState.STARTED);
        if (attributes != null && !attributes.isEmpty()) {
            this.writer.writeln("node " + this.assembleAttributes(attributes));
        }
    }

    public void addDefaultEdgeAttributes(Map<String, String> attributes) throws IOException {
        this.checkState(DotWriterState.STARTED);
        if (attributes != null && !attributes.isEmpty()) {
            this.writer.writeln("edge " + this.assembleAttributes(attributes));
        }
    }

    public void addGraphAttribute(String key, String value) throws IOException {
        this.checkState(DotWriterState.STARTED);
        this.writer.writeln(this.assembleAttribute(key, value));
    }

    public void addNode(String id) throws IOException {
        this.addNode(id, null);
    }

    public void addNode(String id, Map<String, String> attributes) throws IOException {
        this.checkState(DotWriterState.STARTED);
        if (attributes == null || attributes.isEmpty()) {
            this.writer.writeln('\"' + id + '\"');
        } else {
            this.writer.writeln('\"' + id + '\"' + ' ' + this.assembleAttributes(attributes));
        }
    }

    public void addEdge(String sourceId, String targetId) throws IOException {
        this.addEdge(sourceId, targetId, null);
    }

    public void addEdge(String sourceId, String targetId, Map<String, String> attributes) throws IOException {
        this.checkState(DotWriterState.STARTED);
        String edgeConnector = this.graphType == DotGraphType.UNDIRECTED ? "--" : "->";
        if (attributes == null || attributes.isEmpty()) {
            this.writer.writeln('\"' + sourceId + '\"' + ' ' + edgeConnector + ' ' + '\"' + targetId + '\"');
        } else {
            this.writer.writeln('\"' + sourceId + '\"' + ' ' + edgeConnector + ' ' + '\"' + targetId + '\"' + ' ' + this.assembleAttributes(attributes));
        }
    }

    public void addSubgraphStart(String name) throws IOException {
        this.checkState(DotWriterState.STARTED);
        this.writer.writeln("subgraph \"" + name + '\"' + ' ' + "{");
        this.writer.indent();
        ++this.openSubgraphs;
    }

    public void addSubgraphStop() throws IOException {
        this.checkState(DotWriterState.STARTED);
        if (this.openSubgraphs == 0) {
            throw new IllegalStateException("There is no subgraph to close.");
        }
        this.writer.unindent();
        this.writer.writeln("}");
        --this.openSubgraphs;
    }

    public void addClusterStart(String name) throws IOException {
        this.addSubgraphStart("cluster_" + name);
    }

    public void addClusterStop() throws IOException {
        this.addSubgraphStop();
    }

    private void checkState(DotWriterState expectedState) {
        if (this.state != expectedState) {
            switch (expectedState) {
                case CREATED: {
                    throw new IllegalStateException("The writing has already been started.");
                }
                case STARTED: {
                    throw new IllegalStateException("The writing has never started or already been finished.");
                }
                case FINISHED: {
                    throw new IllegalStateException("The writing has not been finished.");
                }
            }
            throw new IllegalStateException();
        }
    }

    private String assembleAttributes(Map<String, String> attributes) {
        return "[" + attributes.entrySet().stream().map(e -> this.assembleAttribute((String)e.getKey(), (String)e.getValue())).collect(Collectors.joining(",")) + "]";
    }

    private String assembleAttribute(String key, String value) {
        return key + "=" + '\"' + value + '\"';
    }

    private static enum DotWriterState {
        CREATED,
        STARTED,
        FINISHED;

    }
}

