/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.BufferUnderflowException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kieker.common.exception.MonitoringRecordException;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.controlflow.BranchingRecord;
import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.common.record.flow.trace.TraceMetadata;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.misc.RegistryRecord;
import kieker.common.record.system.CPUUtilizationRecord;
import kieker.common.record.system.MemSwapUsageRecord;
import kieker.common.record.system.ResourceUtilizationRecord;

public abstract class AbstractMonitoringRecord
implements IMonitoringRecord {
    public static final int TYPE_SIZE_INT = 4;
    public static final int TYPE_SIZE_LONG = 8;
    public static final int TYPE_SIZE_FLOAT = 4;
    public static final int TYPE_SIZE_DOUBLE = 8;
    public static final int TYPE_SIZE_SHORT = 2;
    public static final int TYPE_SIZE_BYTE = 1;
    public static final int TYPE_SIZE_CHARACTER = 2;
    public static final int TYPE_SIZE_STRING = 4;
    public static final int TYPE_SIZE_BOOLEAN = 1;
    private static final float VALID_VARIANCE_FLOAT = 1.0E-5f;
    private static final double VALID_VARIANCE_DOUBLE = 1.0E-5;
    private static final String FAILED_TO_INSTANTIATE_NEW_MONITORING_RECORD_OF_TYPE = "Failed to instantiate new monitoring record of type ";
    private static final long serialVersionUID = 1L;
    private static final ConcurrentMap<String, Class<? extends IMonitoringRecord>> CACHED_KIEKERRECORDS = new ConcurrentHashMap<String, Class<? extends IMonitoringRecord>>();
    private static final ConcurrentMap<Class<? extends IMonitoringRecord>, Class<?>[]> CACHED_KIEKERRECORD_TYPES = new ConcurrentHashMap<Class<? extends IMonitoringRecord>, Class<?>[]>();
    private static final ConcurrentMap<String, Constructor<? extends IMonitoringRecord>> CACHED_KIEKERRECORD_CONSTRUCTORS_BINARY_CHW = new ConcurrentHashMap<String, Constructor<? extends IMonitoringRecord>>();
    private volatile long loggingTimestamp = -1L;

    protected static boolean isNotEqual(double x, double y) {
        double diff = x - y;
        return diff < -1.0E-5 || diff > 1.0E-5;
    }

    protected static boolean isNotEqual(float x, float y) {
        float diff = x - y;
        return diff < -1.0E-5f || diff > 1.0E-5f;
    }

    @Override
    public final long getLoggingTimestamp() {
        return this.loggingTimestamp;
    }

    @Override
    public final void setLoggingTimestamp(long timestamp) {
        this.loggingTimestamp = timestamp;
    }

    @Override
    public int compareTo(IMonitoringRecord otherRecord) {
        long timedifference = this.loggingTimestamp - otherRecord.getLoggingTimestamp();
        if (timedifference < 0L) {
            return -1;
        }
        if (timedifference > 0L) {
            return 1;
        }
        return this.hashCode() - otherRecord.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractMonitoringRecord castedRecord = (AbstractMonitoringRecord)obj;
        return this.getLoggingTimestamp() == castedRecord.getLoggingTimestamp();
    }

    public int hashCode() {
        return Long.hashCode(this.getLoggingTimestamp());
    }

    public static final void checkArray(Object[] values, Class<?>[] valueTypes) {
        if (values.length != valueTypes.length) {
            throw new IllegalArgumentException("Expecting array with " + valueTypes.length + " elements but found " + values.length + " elements.");
        }
        for (int curIdx = 0; curIdx < valueTypes.length; ++curIdx) {
            if (values[curIdx] == null) {
                throw new IllegalArgumentException("Expecting " + valueTypes[curIdx].getName() + " but found null at position " + curIdx + " of the array.");
            }
            if (valueTypes[curIdx] == Integer.TYPE ? values[curIdx] instanceof Integer : (valueTypes[curIdx] == Long.TYPE ? values[curIdx] instanceof Long : (valueTypes[curIdx] == String.class ? values[curIdx] instanceof String : (valueTypes[curIdx] == Integer.class ? values[curIdx] instanceof Integer : (valueTypes[curIdx] == Long.class ? values[curIdx] instanceof Long : (valueTypes[curIdx] == Float.TYPE ? values[curIdx] instanceof Float : (valueTypes[curIdx] == Float.class ? values[curIdx] instanceof Float : (valueTypes[curIdx] == Double.TYPE ? values[curIdx] instanceof Double : (valueTypes[curIdx] == Double.class ? values[curIdx] instanceof Double : (valueTypes[curIdx] == Byte.TYPE ? values[curIdx] instanceof Byte : (valueTypes[curIdx] == Byte.class ? values[curIdx] instanceof Byte : (valueTypes[curIdx] == Short.TYPE ? values[curIdx] instanceof Short : (valueTypes[curIdx] == Short.class ? values[curIdx] instanceof Short : (valueTypes[curIdx] == Boolean.TYPE ? values[curIdx] instanceof Boolean : (valueTypes[curIdx] == Boolean.class ? values[curIdx] instanceof Boolean : valueTypes[curIdx].equals(values[curIdx].getClass())))))))))))))))) continue;
            throw new IllegalArgumentException("Expecting " + valueTypes[curIdx].getName() + " but found " + values[curIdx].getClass().getName() + " at position " + curIdx + " of the array.");
        }
    }

    public static final Object[] fromStringArrayToTypedArray2(String[] recordFields, Class<?>[] valueTypes) throws IllegalArgumentException {
        if (recordFields.length != valueTypes.length) {
            throw new IllegalArgumentException("Expected " + valueTypes.length + " record fields, but found " + recordFields.length);
        }
        Object[] typedArray = new Object[recordFields.length];
        for (int curIdx = 0; curIdx < typedArray.length; ++curIdx) {
            if (valueTypes[curIdx] == String.class) {
                typedArray[curIdx] = recordFields[curIdx];
                continue;
            }
            if (valueTypes[curIdx] == Integer.TYPE) {
                typedArray[curIdx] = Integer.valueOf(recordFields[curIdx]);
                continue;
            }
            if (valueTypes[curIdx] == Long.TYPE) {
                typedArray[curIdx] = Long.valueOf(recordFields[curIdx]);
                continue;
            }
            if (valueTypes[curIdx] == Integer.class) {
                typedArray[curIdx] = Integer.valueOf(recordFields[curIdx]);
                continue;
            }
            if (valueTypes[curIdx] == Long.class) {
                typedArray[curIdx] = Long.valueOf(recordFields[curIdx]);
                continue;
            }
            if (valueTypes[curIdx] == Float.TYPE) {
                typedArray[curIdx] = Float.valueOf(recordFields[curIdx]);
                continue;
            }
            if (valueTypes[curIdx] == Float.class) {
                typedArray[curIdx] = Float.valueOf(recordFields[curIdx]);
                continue;
            }
            if (valueTypes[curIdx] == Double.TYPE) {
                typedArray[curIdx] = Double.valueOf(recordFields[curIdx]);
                continue;
            }
            if (valueTypes[curIdx] == Double.class) {
                typedArray[curIdx] = Double.valueOf(recordFields[curIdx]);
                continue;
            }
            if (valueTypes[curIdx] == Byte.TYPE) {
                typedArray[curIdx] = Byte.valueOf(recordFields[curIdx]);
                continue;
            }
            if (valueTypes[curIdx] == Byte.class) {
                typedArray[curIdx] = Byte.valueOf(recordFields[curIdx]);
                continue;
            }
            if (valueTypes[curIdx] == Short.TYPE) {
                typedArray[curIdx] = Short.valueOf(recordFields[curIdx]);
                continue;
            }
            if (valueTypes[curIdx] == Short.class) {
                typedArray[curIdx] = Short.valueOf(recordFields[curIdx]);
                continue;
            }
            if (valueTypes[curIdx] == Boolean.TYPE) {
                typedArray[curIdx] = Boolean.valueOf(recordFields[curIdx]);
                continue;
            }
            if (valueTypes[curIdx] == Boolean.class) {
                typedArray[curIdx] = Boolean.valueOf(recordFields[curIdx]);
                continue;
            }
            throw new IllegalArgumentException("Unsupported type: " + valueTypes[curIdx].getName());
        }
        return typedArray;
    }

    public static final Class<? extends IMonitoringRecord> classForName(String classname) throws MonitoringRecordException {
        Class<IMonitoringRecord> clazz = (Class<IMonitoringRecord>)CACHED_KIEKERRECORDS.get(classname);
        if (clazz == null) {
            try {
                clazz = Class.forName(classname).asSubclass(IMonitoringRecord.class);
                CACHED_KIEKERRECORDS.putIfAbsent(classname, clazz);
            }
            catch (ClassCastException | ClassNotFoundException ex) {
                throw new MonitoringRecordException("Failed to get record type of name " + classname, ex);
            }
        }
        return clazz;
    }

    public static final Class<?>[] typesForClass(Class<? extends IMonitoringRecord> clazz) throws MonitoringRecordException {
        Class[] types = (Class[])CACHED_KIEKERRECORD_TYPES.get(clazz);
        if (types == null) {
            try {
                if (IMonitoringRecord.class.isAssignableFrom(clazz)) {
                    Field typesField = clazz.getDeclaredField("TYPES");
                    types = (Class[])typesField.get(null);
                } else {
                    types = clazz.newInstance().getValueTypes();
                }
                CACHED_KIEKERRECORD_TYPES.putIfAbsent(clazz, types);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | SecurityException ex) {
                throw new MonitoringRecordException("Failed to get types for monitoring record of type " + clazz.getName(), ex);
            }
        }
        return types;
    }

    public static final IMonitoringRecord createFromDeserializer(String recordClassName, IValueDeserializer deserializer) throws BufferUnderflowException, MonitoringRecordException {
        try {
            Constructor<? extends IMonitoringRecord> constructor = (Constructor<? extends IMonitoringRecord>)CACHED_KIEKERRECORD_CONSTRUCTORS_BINARY_CHW.get(recordClassName);
            if (constructor == null) {
                Class<? extends IMonitoringRecord> clazz = AbstractMonitoringRecord.classForName(recordClassName);
                if (IMonitoringRecord.class.isAssignableFrom(clazz)) {
                    constructor = clazz.getConstructor(IValueDeserializer.class);
                    CACHED_KIEKERRECORD_CONSTRUCTORS_BINARY_CHW.putIfAbsent(recordClassName, constructor);
                } else {
                    throw new MonitoringRecordException("No factory for record type " + recordClassName + ".");
                }
            }
            return (IMonitoringRecord)constructor.newInstance(deserializer);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException ex) {
            throw new MonitoringRecordException(FAILED_TO_INSTANTIATE_NEW_MONITORING_RECORD_OF_TYPE + recordClassName, ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof BufferUnderflowException) {
                throw (BufferUnderflowException)cause;
            }
            throw new MonitoringRecordException(FAILED_TO_INSTANTIATE_NEW_MONITORING_RECORD_OF_TYPE + recordClassName, ex);
        }
    }

    static {
        CACHED_KIEKERRECORDS.put("kieker.tpmon.monitoringRecord.executions.KiekerExecutionRecord", OperationExecutionRecord.class);
        CACHED_KIEKERRECORDS.put("kieker.common.record.CPUUtilizationRecord", CPUUtilizationRecord.class);
        CACHED_KIEKERRECORDS.put("kieker.common.record.MemSwapUsageRecord", MemSwapUsageRecord.class);
        CACHED_KIEKERRECORDS.put("kieker.common.record.ResourceUtilizationRecord", ResourceUtilizationRecord.class);
        CACHED_KIEKERRECORDS.put("kieker.common.record.OperationExecutionRecord", OperationExecutionRecord.class);
        CACHED_KIEKERRECORDS.put("kieker.common.record.BranchingRecord", BranchingRecord.class);
        CACHED_KIEKERRECORDS.put("kieker.monitoring.core.registry.RegistryRecord", RegistryRecord.class);
        CACHED_KIEKERRECORDS.put("kieker.common.record.flow.trace.Trace", TraceMetadata.class);
    }
}

