/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace.operation;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.flow.ICallRecord;
import kieker.common.record.flow.trace.operation.AbstractOperationEvent;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class CallOperationEvent
extends AbstractOperationEvent
implements ICallRecord {
    public static final int SIZE = 36;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, String.class, String.class, String.class, String.class};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "traceId", "orderIndex", "operationSignature", "classSignature", "calleeOperationSignature", "calleeClassSignature"};
    public static final String CALLEE_OPERATION_SIGNATURE = "";
    public static final String CALLEE_CLASS_SIGNATURE = "";
    private static final long serialVersionUID = 2408771186779452968L;
    private final String calleeOperationSignature;
    private final String calleeClassSignature;

    public CallOperationEvent(long timestamp, long traceId, int orderIndex, String operationSignature, String classSignature, String calleeOperationSignature, String calleeClassSignature) {
        super(timestamp, traceId, orderIndex, operationSignature, classSignature);
        this.calleeOperationSignature = calleeOperationSignature == null ? "" : calleeOperationSignature;
        this.calleeClassSignature = calleeClassSignature == null ? "" : calleeClassSignature;
    }

    public CallOperationEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        super(deserializer);
        this.calleeOperationSignature = deserializer.getString();
        this.calleeClassSignature = deserializer.getString();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putLong(this.getTraceId());
        serializer.putInt(this.getOrderIndex());
        serializer.putString(this.getOperationSignature());
        serializer.putString(this.getClassSignature());
        serializer.putString(this.getCalleeOperationSignature());
        serializer.putString(this.getCalleeClassSignature());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 36;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        CallOperationEvent castedRecord = (CallOperationEvent)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (this.getTimestamp() != castedRecord.getTimestamp()) {
            return false;
        }
        if (this.getTraceId() != castedRecord.getTraceId()) {
            return false;
        }
        if (this.getOrderIndex() != castedRecord.getOrderIndex()) {
            return false;
        }
        if (!this.getOperationSignature().equals(castedRecord.getOperationSignature())) {
            return false;
        }
        if (!this.getClassSignature().equals(castedRecord.getClassSignature())) {
            return false;
        }
        if (!this.getCalleeOperationSignature().equals(castedRecord.getCalleeOperationSignature())) {
            return false;
        }
        return this.getCalleeClassSignature().equals(castedRecord.getCalleeClassSignature());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += (int)this.getTraceId();
        code += this.getOrderIndex();
        code += this.getOperationSignature().hashCode();
        code += this.getClassSignature().hashCode();
        code += this.getCalleeOperationSignature().hashCode();
        return code += this.getCalleeClassSignature().hashCode();
    }

    @Override
    public final String getCallerOperationSignature() {
        return this.getOperationSignature();
    }

    @Override
    public final String getCallerClassSignature() {
        return this.getClassSignature();
    }

    @Override
    public final String getCalleeOperationSignature() {
        return this.calleeOperationSignature;
    }

    @Override
    public final String getCalleeClassSignature() {
        return this.calleeClassSignature;
    }

    @Override
    public String toString() {
        String result = "CallOperationEvent: ";
        result = result + "timestamp = ";
        result = result + this.getTimestamp() + ", ";
        result = result + "traceId = ";
        result = result + this.getTraceId() + ", ";
        result = result + "orderIndex = ";
        result = result + this.getOrderIndex() + ", ";
        result = result + "operationSignature = ";
        result = result + this.getOperationSignature() + ", ";
        result = result + "classSignature = ";
        result = result + this.getClassSignature() + ", ";
        result = result + "calleeOperationSignature = ";
        result = result + this.getCalleeOperationSignature() + ", ";
        result = result + "calleeClassSignature = ";
        result = result + this.getCalleeClassSignature() + ", ";
        return result;
    }
}

