/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace.operation.constructor;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.flow.IConstructorRecord;
import kieker.common.record.flow.trace.operation.AfterOperationFailedEvent;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;

public class AfterConstructorFailedEvent
extends AfterOperationFailedEvent
implements IConstructorRecord {
    public static final int SIZE = 32;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, String.class, String.class, String.class};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "traceId", "orderIndex", "operationSignature", "classSignature", "cause"};
    private static final long serialVersionUID = 625847064598823017L;

    public AfterConstructorFailedEvent(long timestamp, long traceId, int orderIndex, String operationSignature, String classSignature, String cause) {
        super(timestamp, traceId, orderIndex, operationSignature, classSignature, cause);
    }

    public AfterConstructorFailedEvent(IValueDeserializer deserializer) throws RecordInstantiationException {
        super(deserializer);
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putLong(this.getTraceId());
        serializer.putInt(this.getOrderIndex());
        serializer.putString(this.getOperationSignature());
        serializer.putString(this.getClassSignature());
        serializer.putString(this.getCause());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 32;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AfterConstructorFailedEvent castedRecord = (AfterConstructorFailedEvent)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (this.getTimestamp() != castedRecord.getTimestamp()) {
            return false;
        }
        if (this.getTraceId() != castedRecord.getTraceId()) {
            return false;
        }
        if (this.getOrderIndex() != castedRecord.getOrderIndex()) {
            return false;
        }
        if (!this.getOperationSignature().equals(castedRecord.getOperationSignature())) {
            return false;
        }
        if (!this.getClassSignature().equals(castedRecord.getClassSignature())) {
            return false;
        }
        return this.getCause().equals(castedRecord.getCause());
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += (int)this.getTraceId();
        code += this.getOrderIndex();
        code += this.getOperationSignature().hashCode();
        code += this.getClassSignature().hashCode();
        return code += this.getCause().hashCode();
    }

    @Override
    public String toString() {
        String result = "AfterConstructorFailedEvent: ";
        result = result + "timestamp = ";
        result = result + this.getTimestamp() + ", ";
        result = result + "traceId = ";
        result = result + this.getTraceId() + ", ";
        result = result + "orderIndex = ";
        result = result + this.getOrderIndex() + ", ";
        result = result + "operationSignature = ";
        result = result + this.getOperationSignature() + ", ";
        result = result + "classSignature = ";
        result = result + this.getClassSignature() + ", ";
        result = result + "cause = ";
        result = result + this.getCause() + ", ";
        return result;
    }
}

