/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.jvm;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;
import kieker.common.record.jvm.AbstractJVMRecord;

public class ClassLoadingRecord
extends AbstractJVMRecord {
    public static final int SIZE = 36;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, String.class, Long.TYPE, Integer.TYPE, Long.TYPE};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "hostname", "vmName", "totalLoadedClassCount", "loadedClassCount", "unloadedClassCount"};
    private static final long serialVersionUID = -5955568375346711225L;
    private final long totalLoadedClassCount;
    private final int loadedClassCount;
    private final long unloadedClassCount;

    public ClassLoadingRecord(long timestamp, String hostname, String vmName, long totalLoadedClassCount, int loadedClassCount, long unloadedClassCount) {
        super(timestamp, hostname, vmName);
        this.totalLoadedClassCount = totalLoadedClassCount;
        this.loadedClassCount = loadedClassCount;
        this.unloadedClassCount = unloadedClassCount;
    }

    public ClassLoadingRecord(IValueDeserializer deserializer) throws RecordInstantiationException {
        super(deserializer);
        this.totalLoadedClassCount = deserializer.getLong();
        this.loadedClassCount = deserializer.getInt();
        this.unloadedClassCount = deserializer.getLong();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putString(this.getHostname());
        serializer.putString(this.getVmName());
        serializer.putLong(this.getTotalLoadedClassCount());
        serializer.putInt(this.getLoadedClassCount());
        serializer.putLong(this.getUnloadedClassCount());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 36;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ClassLoadingRecord castedRecord = (ClassLoadingRecord)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (this.getTimestamp() != castedRecord.getTimestamp()) {
            return false;
        }
        if (!this.getHostname().equals(castedRecord.getHostname())) {
            return false;
        }
        if (!this.getVmName().equals(castedRecord.getVmName())) {
            return false;
        }
        if (this.getTotalLoadedClassCount() != castedRecord.getTotalLoadedClassCount()) {
            return false;
        }
        if (this.getLoadedClassCount() != castedRecord.getLoadedClassCount()) {
            return false;
        }
        return this.getUnloadedClassCount() == castedRecord.getUnloadedClassCount();
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += this.getHostname().hashCode();
        code += this.getVmName().hashCode();
        code += (int)this.getTotalLoadedClassCount();
        code += this.getLoadedClassCount();
        return code += (int)this.getUnloadedClassCount();
    }

    public final long getTotalLoadedClassCount() {
        return this.totalLoadedClassCount;
    }

    public final int getLoadedClassCount() {
        return this.loadedClassCount;
    }

    public final long getUnloadedClassCount() {
        return this.unloadedClassCount;
    }

    @Override
    public String toString() {
        String result = "ClassLoadingRecord: ";
        result = result + "timestamp = ";
        result = result + this.getTimestamp() + ", ";
        result = result + "hostname = ";
        result = result + this.getHostname() + ", ";
        result = result + "vmName = ";
        result = result + this.getVmName() + ", ";
        result = result + "totalLoadedClassCount = ";
        result = result + this.getTotalLoadedClassCount() + ", ";
        result = result + "loadedClassCount = ";
        result = result + this.getLoadedClassCount() + ", ";
        result = result + "unloadedClassCount = ";
        result = result + this.getUnloadedClassCount() + ", ";
        return result;
    }
}

