/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.jvm;

import java.nio.BufferOverflowException;
import kieker.common.exception.RecordInstantiationException;
import kieker.common.record.io.IValueDeserializer;
import kieker.common.record.io.IValueSerializer;
import kieker.common.record.jvm.AbstractJVMRecord;

public class UptimeRecord
extends AbstractJVMRecord {
    public static final int SIZE = 24;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, String.class, Long.TYPE};
    public static final String[] VALUE_NAMES = new String[]{"timestamp", "hostname", "vmName", "uptimeMS"};
    private static final long serialVersionUID = 5233115844046765277L;
    private final long uptimeMS;

    public UptimeRecord(long timestamp, String hostname, String vmName, long uptimeMS) {
        super(timestamp, hostname, vmName);
        this.uptimeMS = uptimeMS;
    }

    public UptimeRecord(IValueDeserializer deserializer) throws RecordInstantiationException {
        super(deserializer);
        this.uptimeMS = deserializer.getLong();
    }

    @Override
    public void serialize(IValueSerializer serializer) throws BufferOverflowException {
        serializer.putLong(this.getTimestamp());
        serializer.putString(this.getHostname());
        serializer.putString(this.getVmName());
        serializer.putLong(this.getUptimeMS());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public String[] getValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public int getSize() {
        return 24;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        UptimeRecord castedRecord = (UptimeRecord)obj;
        if (this.getLoggingTimestamp() != castedRecord.getLoggingTimestamp()) {
            return false;
        }
        if (this.getTimestamp() != castedRecord.getTimestamp()) {
            return false;
        }
        if (!this.getHostname().equals(castedRecord.getHostname())) {
            return false;
        }
        if (!this.getVmName().equals(castedRecord.getVmName())) {
            return false;
        }
        return this.getUptimeMS() == castedRecord.getUptimeMS();
    }

    @Override
    public int hashCode() {
        int code = 0;
        code += (int)this.getTimestamp();
        code += this.getHostname().hashCode();
        code += this.getVmName().hashCode();
        return code += (int)this.getUptimeMS();
    }

    public final long getUptimeMS() {
        return this.uptimeMS;
    }

    @Override
    public String toString() {
        String result = "UptimeRecord: ";
        result = result + "timestamp = ";
        result = result + this.getTimestamp() + ", ";
        result = result + "hostname = ";
        result = result + this.getHostname() + ", ";
        result = result + "vmName = ";
        result = result + this.getVmName() + ", ";
        result = result + "uptimeMS = ";
        result = result + this.getUptimeMS() + ", ";
        return result;
    }
}

