/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.util.map;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ConcurrentHashMap;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class BoundedConcurrentHashMap<K, V>
extends ConcurrentHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private final BoundedCacheBehaviour boundedCacheBehaviour;
    private final int maxCacheSize;

    public BoundedConcurrentHashMap(BoundedCacheBehaviour boundedCacheBehaviour, int maxCacheSize) {
        this.boundedCacheBehaviour = boundedCacheBehaviour;
        this.maxCacheSize = maxCacheSize;
    }

    @Override
    public V put(K key, V value) {
        if (this.checkBounds()) {
            return super.put(key, value);
        }
        return null;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (this.checkBounds()) {
            return super.putIfAbsent(key, value);
        }
        return null;
    }

    private boolean checkBounds() {
        boolean elementCanBeAdded;
        switch (this.boundedCacheBehaviour) {
            case IGNORE_NEW_ENTRIES: {
                elementCanBeAdded = this.size() < this.maxCacheSize;
                break;
            }
            case REMOVE_RANDOM_ENTRY: {
                if (this.size() >= this.maxCacheSize) {
                    this.remove(this.keys().nextElement());
                }
                elementCanBeAdded = true;
                break;
            }
            case CLEAR_CACHE: {
                if (this.size() >= this.maxCacheSize) {
                    this.clear();
                }
                elementCanBeAdded = true;
                break;
            }
            default: {
                elementCanBeAdded = true;
            }
        }
        return elementCanBeAdded;
    }

    public static enum BoundedCacheBehaviour {
        IGNORE_NEW_ENTRIES,
        REMOVE_RANDOM_ENTRY,
        CLEAR_CACHE;

    }
}

