/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.controller;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import kieker.common.configuration.Configuration;
import kieker.common.util.map.BoundedConcurrentHashMap;
import kieker.monitoring.core.controller.AbstractController;
import kieker.monitoring.core.controller.IProbeController;
import kieker.monitoring.core.controller.SamplingController;
import kieker.monitoring.core.signaturePattern.InvalidPatternException;
import kieker.monitoring.core.signaturePattern.PatternEntry;
import kieker.monitoring.core.signaturePattern.PatternParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProbeController
extends AbstractController
implements IProbeController {
    static final Logger LOGGER = LoggerFactory.getLogger(ProbeController.class);
    private static final String ENCODING = "UTF-8";
    private final boolean enabled;
    private final String configFilePathname;
    private final boolean configFileUpdate;
    private final int configFileReadIntervall;
    private final int maxCacheSize;
    private final int boundedCacheBehaviour;
    private final ConfigFileReader configFileReader;
    private final ConcurrentMap<String, Boolean> signatureCache;
    private final List<PatternEntry> patterns = new ArrayList<PatternEntry>();
    private final Map<String, Map<String, List<String>>> patternListParameters = new ConcurrentHashMap<String, Map<String, List<String>>>();

    protected ProbeController(Configuration configuration) {
        super(configuration);
        this.enabled = configuration.getBooleanProperty("kieker.monitoring.adaptiveMonitoring.enabled");
        if (this.enabled) {
            this.configFilePathname = configuration.getPathProperty("kieker.monitoring.adaptiveMonitoring.configFile");
            this.configFileUpdate = configuration.getBooleanProperty("kieker.monitoring.adaptiveMonitoring.updateConfigFile");
            this.configFileReadIntervall = configuration.getIntProperty("kieker.monitoring.adaptiveMonitoring.readInterval");
            this.maxCacheSize = configuration.getIntProperty("kieker.monitoring.adaptiveMonitoring.maxCacheSize");
            this.boundedCacheBehaviour = configuration.getIntProperty("kieker.monitoring.adaptiveMonitoring.boundedCacheBehaviour");
            if (this.maxCacheSize >= 0) {
                int cacheSize;
                BoundedConcurrentHashMap.BoundedCacheBehaviour behaviour;
                switch (this.boundedCacheBehaviour) {
                    case 0: {
                        behaviour = BoundedConcurrentHashMap.BoundedCacheBehaviour.IGNORE_NEW_ENTRIES;
                        break;
                    }
                    case 1: {
                        behaviour = BoundedConcurrentHashMap.BoundedCacheBehaviour.REMOVE_RANDOM_ENTRY;
                        break;
                    }
                    case 2: {
                        behaviour = BoundedConcurrentHashMap.BoundedCacheBehaviour.CLEAR_CACHE;
                        break;
                    }
                    default: {
                        LOGGER.warn("Unexpected value for property '{}'. Using default value 0.", (Object)"kieker.monitoring.adaptiveMonitoring.boundedCacheBehaviour");
                        behaviour = BoundedConcurrentHashMap.BoundedCacheBehaviour.IGNORE_NEW_ENTRIES;
                    }
                }
                if (this.maxCacheSize >= 1) {
                    cacheSize = this.maxCacheSize;
                } else {
                    LOGGER.warn("Invalid value for property '{}'. Using default value 100.", (Object)"kieker.monitoring.adaptiveMonitoring.maxCacheSize");
                    cacheSize = 100;
                }
                this.signatureCache = new BoundedConcurrentHashMap<String, Boolean>(behaviour, cacheSize);
            } else {
                this.signatureCache = new ConcurrentHashMap<String, Boolean>();
            }
            this.configFileReader = new ConfigFileReader(this.configFilePathname);
            this.configFileReader.readFile(true);
        } else {
            this.configFilePathname = null;
            this.configFileUpdate = false;
            this.configFileReadIntervall = 0;
            this.maxCacheSize = 0;
            this.boundedCacheBehaviour = 0;
            this.configFileReader = null;
            this.signatureCache = new ConcurrentHashMap<String, Boolean>();
        }
    }

    @Override
    protected void init() {
        if (this.enabled && this.monitoringController != null) {
            SamplingController samplingController = this.monitoringController.getSamplingController();
            ScheduledThreadPoolExecutor scheduler = samplingController.periodicSensorsPoolExecutor;
            if (this.configFileReadIntervall > 0 && null != scheduler) {
                scheduler.scheduleWithFixedDelay(this.configFileReader, this.configFileReadIntervall, this.configFileReadIntervall, TimeUnit.SECONDS);
            } else if (this.configFileReadIntervall > 0 && null == scheduler) {
                LOGGER.warn("Failed to enable regular reading of adaptive monitoring config file. '{}' must be > 0!", (Object)"kieker.monitoring.periodicSensorsExecutorPoolSize");
            }
        }
    }

    @Override
    protected void cleanup() {
        LOGGER.debug("Shutting down Probe Controller");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(255);
        sb.append("ProbeController: ");
        if (this.enabled) {
            sb.append('\'');
            sb.append(this.configFilePathname);
            sb.append("'\n\tTime intervall for update checks of pattern file (in seconds): ");
            if (this.configFileReadIntervall > 0) {
                sb.append(this.configFileReadIntervall);
            } else {
                sb.append("deactivated");
            }
            sb.append("\n\tUpdate pattern file with additional patterns: ");
            sb.append(this.configFileUpdate);
            sb.append("\n\tSignature cache: ");
            if (this.maxCacheSize >= 0) {
                sb.append("bounded");
            } else {
                sb.append("unbounded");
            }
        } else {
            sb.append("disabled");
        }
        sb.append('\n');
        return sb.toString();
    }

    @Override
    public boolean activateProbe(String pattern) {
        return this.addPattern(pattern, true);
    }

    @Override
    public boolean deactivateProbe(String pattern) {
        return this.addPattern(pattern, false);
    }

    @Override
    public boolean isProbeActivated(String signature) {
        if (this.enabled) {
            Boolean active = (Boolean)this.signatureCache.get(signature);
            if (null == active) {
                return this.matchesPattern(signature);
            }
            return active;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setProbePatternList(List<String> strPatternList, boolean updateConfig) {
        if (!this.enabled) {
            LOGGER.warn("Adapative Monitoring is disabled!");
            return;
        }
        ProbeController probeController = this;
        synchronized (probeController) {
            this.patterns.clear();
            this.signatureCache.clear();
            for (String pattern : strPatternList) {
                this.addToPatternEntryList(pattern);
            }
            if (updateConfig && this.configFileUpdate) {
                this.updatePatternFile();
            }
        }
    }

    private void addToPatternEntryList(String pattern) {
        if (pattern.length() == 0) {
            return;
        }
        try {
            switch (pattern.charAt(0)) {
                case '+': {
                    this.patterns.add(new PatternEntry(pattern.substring(1).trim(), true));
                    break;
                }
                case '-': {
                    this.patterns.add(new PatternEntry(pattern.substring(1).trim(), false));
                    break;
                }
                case '#': {
                    break;
                }
                default: {
                    LOGGER.warn("Each line should either start with '+', '-', or '#'. Ignoring: {}", (Object)pattern);
                    break;
                }
            }
        }
        catch (InvalidPatternException ex) {
            LOGGER.error("'{}' is not a valid pattern.", (Object)pattern.substring(1), (Object)ex);
        }
    }

    @Override
    public void setProbePatternList(List<String> strPatternList) {
        this.setProbePatternList(strPatternList, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getProbePatternList() {
        if (!this.enabled) {
            LOGGER.warn("Adapative Monitoring is disabled!");
            return new ArrayList<String>(0);
        }
        ProbeController probeController = this;
        synchronized (probeController) {
            ArrayList<String> currentPatterns = new ArrayList<String>(this.patterns.size());
            for (PatternEntry entry : this.patterns) {
                String strPattern = entry.isActivated() ? '+' + entry.getStrPattern() : '-' + entry.getStrPattern();
                currentPatterns.add(strPattern);
            }
            return currentPatterns;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<String>> getAllPatternParameters(String pattern) {
        ProbeController probeController = this;
        synchronized (probeController) {
            return this.patternListParameters.get(pattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePatternParameter(String pattern, String name) {
        ProbeController probeController = this;
        synchronized (probeController) {
            Map<String, List<String>> parameters = this.patternListParameters.get(pattern);
            if (parameters != null) {
                parameters.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPatternParameters(String pattern) {
        ProbeController probeController = this;
        synchronized (probeController) {
            this.patternListParameters.remove(pattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPatternParameter(String pattern, String name, List<String> values) {
        ProbeController probeController = this;
        synchronized (probeController) {
            Map<String, List<String>> parameters = this.patternListParameters.get(pattern);
            if (parameters == null) {
                parameters = new HashMap<String, List<String>>();
                this.patternListParameters.put(pattern, parameters);
            }
            parameters.put(name, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPatternParameterValue(String pattern, String name, String value) {
        ProbeController probeController = this;
        synchronized (probeController) {
            Map<String, List<String>> parameters = this.patternListParameters.get(pattern);
            if (parameters == null) {
                parameters = new HashMap<String, List<String>>();
                this.patternListParameters.put(pattern, parameters);
                ArrayList<String> values = new ArrayList<String>();
                values.add(value);
                parameters.put(name, values);
            } else {
                parameters.get(name).add(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePatternParameterValue(String pattern, String name, String value) {
        ProbeController probeController = this;
        synchronized (probeController) {
            List<String> values;
            Map<String, List<String>> parameters = this.patternListParameters.get(pattern);
            if (parameters != null && (values = parameters.get(name)) != null) {
                values.remove(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchesPattern(String signature) {
        ProbeController probeController = this;
        synchronized (probeController) {
            ListIterator<PatternEntry> patternListIterator = this.patterns.listIterator(this.patterns.size());
            while (patternListIterator.hasPrevious()) {
                PatternEntry patternEntry = patternListIterator.previous();
                if (!patternEntry.getPattern().matcher(signature).matches()) continue;
                boolean value = patternEntry.isActivated();
                this.signatureCache.put(signature, value);
                return value;
            }
        }
        this.signatureCache.put(signature, true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addPattern(String strPattern, boolean activated) {
        if (!this.enabled) {
            LOGGER.warn("Adapative Monitoring is disabled!");
            return false;
        }
        ProbeController probeController = this;
        synchronized (probeController) {
            Pattern pattern;
            this.signatureCache.clear();
            try {
                pattern = PatternParser.parseToPattern(strPattern);
            }
            catch (InvalidPatternException ex) {
                LOGGER.error("'{}' is not a valid pattern.", (Object)strPattern, (Object)ex);
                return false;
            }
            this.patterns.add(new PatternEntry(strPattern, pattern, activated));
            if (this.configFileUpdate) {
                this.updatePatternFile();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePatternFile() {
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.configFilePathname, false), ENCODING)));
            pw.print("## Adaptive Monitoring Config File: ");
            pw.println(this.configFilePathname);
            pw.print("## written on: ");
            SimpleDateFormat date = new SimpleDateFormat("yyyyMMdd'-'HHmmssSSS", Locale.US);
            date.setTimeZone(TimeZone.getTimeZone("UTC"));
            pw.println(date.format(new Date()));
            pw.println('#');
            List<String> strPatterns = this.getProbePatternList();
            for (String string : strPatterns) {
                pw.println(string);
            }
        }
        this.configFileReader.lastModifiedTimestamp = System.currentTimeMillis();
        LOGGER.info("Updating Adaptive Monitoring config file succeeded.");
    }

    private final class ConfigFileReader
    implements Runnable {
        private final String configFilePathname;
        volatile long lastModifiedTimestamp;

        public ConfigFileReader(String configFilePathname) {
            this.configFilePathname = configFilePathname;
        }

        private List<String> readConfigFile(BufferedReader reader) throws IOException {
            String line;
            LinkedList<String> strPatternList = new LinkedList<String>();
            while ((line = reader.readLine()) != null) {
                strPatternList.add(line);
            }
            return strPatternList;
        }

        /*
         * Exception decompiling
         */
        public void readFile(boolean fallbackToResource) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void run() {
            this.readFile(false);
        }
    }
}

