/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.controller;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kieker.common.configuration.Configuration;
import kieker.monitoring.core.controller.AbstractController;
import kieker.monitoring.core.controller.ISamplingController;
import kieker.monitoring.core.sampler.ISampler;
import kieker.monitoring.core.sampler.ScheduledSamplerJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SamplingController
extends AbstractController
implements ISamplingController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamplingController.class);
    final ScheduledThreadPoolExecutor periodicSensorsPoolExecutor;

    protected SamplingController(Configuration configuration) {
        super(configuration);
        int threadPoolSize = configuration.getIntProperty("kieker.monitoring.periodicSensorsExecutorPoolSize");
        if (threadPoolSize > 0) {
            this.periodicSensorsPoolExecutor = new ScheduledThreadPoolExecutor(threadPoolSize, new DaemonThreadFactory(), new RejectedExecutionHandler());
            this.periodicSensorsPoolExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.periodicSensorsPoolExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        } else {
            this.periodicSensorsPoolExecutor = null;
        }
    }

    @Override
    protected final void init() {
    }

    @Override
    protected final void cleanup() {
        LOGGER.debug("Shutting down Sampling Controller");
        if (this.periodicSensorsPoolExecutor != null) {
            this.periodicSensorsPoolExecutor.shutdown();
        }
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Sampling Controller: ");
        if (this.periodicSensorsPoolExecutor != null) {
            sb.append("Periodic Sensor available: Poolsize: '");
            sb.append(this.periodicSensorsPoolExecutor.getPoolSize());
            sb.append("'; Scheduled Tasks: '");
            sb.append(this.periodicSensorsPoolExecutor.getTaskCount());
            sb.append('\'');
        } else {
            sb.append("No periodic Sensor available");
        }
        return sb.toString();
    }

    @Override
    public final ScheduledSamplerJob schedulePeriodicSampler(ISampler sensor, long initialDelay, long period, TimeUnit timeUnit) {
        if (null == this.periodicSensorsPoolExecutor) {
            LOGGER.warn("Won't schedule periodic sensor since Periodic Sampling is deactivated.");
            return null;
        }
        ScheduledSamplerJob job = new ScheduledSamplerJob(this.monitoringController, sensor);
        ScheduledFuture<?> future = this.periodicSensorsPoolExecutor.scheduleAtFixedRate(job, initialDelay, period, timeUnit);
        job.setFuture(future);
        return job;
    }

    @Override
    public final boolean removeScheduledSampler(ScheduledSamplerJob sensorJob) {
        if (null == this.periodicSensorsPoolExecutor) {
            LOGGER.warn("Won't schedule periodic sensor since Periodic Sampling is deactivated.");
            return false;
        }
        ScheduledFuture<?> future = sensorJob.getFuture();
        if (future != null) {
            future.cancel(false);
        } else {
            LOGGER.warn("ScheduledFuture of ScheduledSamplerJob null: {}", (Object)sensorJob);
        }
        boolean success = this.periodicSensorsPoolExecutor.remove(sensorJob);
        this.periodicSensorsPoolExecutor.purge();
        return success;
    }

    private static final class DaemonThreadFactory
    implements ThreadFactory {
        private final ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.defaultThreadFactory.newThread(r);
            t.setDaemon(true);
            return t;
        }
    }

    private static final class RejectedExecutionHandler
    implements java.util.concurrent.RejectedExecutionHandler {
        private static final Logger LOGGER = LoggerFactory.getLogger(RejectedExecutionHandler.class);

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            LOGGER.error("Exception caught by RejectedExecutionHandler for Runnable {} and ThreadPoolExecutor {}", (Object)r, (Object)executor);
        }
    }
}

