/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.controller;

import kieker.common.configuration.Configuration;
import kieker.monitoring.core.controller.AbstractController;
import kieker.monitoring.core.controller.ITimeSourceController;
import kieker.monitoring.timer.ITimeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeSourceController
extends AbstractController
implements ITimeSourceController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeSourceController.class);
    private final ITimeSource timeSource;

    protected TimeSourceController(Configuration configuration) {
        super(configuration);
        this.timeSource = AbstractController.createAndInitialize(ITimeSource.class, configuration.getStringProperty("kieker.monitoring.timer"), configuration);
        if (this.timeSource == null) {
            this.terminate();
        }
    }

    @Override
    protected final void init() {
    }

    @Override
    protected final void cleanup() {
        LOGGER.debug("Shutting down TimeSource Controller");
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("TimeSource: ");
        if (this.timeSource != null) {
            sb.append('\'');
            sb.append(this.getTimeSource().getClass().getName());
            sb.append("'\n\t");
            sb.append(this.getTimeSource().toString());
            sb.append("'\n");
        } else {
            sb.append("No TimeSource available\n");
        }
        return sb.toString();
    }

    @Override
    public final ITimeSource getTimeSource() {
        return this.timeSource;
    }
}

