/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.controller;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.core.controller.AbstractController;
import kieker.monitoring.core.controller.IWriterController;
import kieker.monitoring.queue.BlockingQueueDecorator;
import kieker.monitoring.queue.behavior.BlockOnFailedInsertBehavior;
import kieker.monitoring.queue.behavior.BypassQueueBehavior;
import kieker.monitoring.queue.behavior.CountOnFailedInsertBehavior;
import kieker.monitoring.queue.behavior.DoNotInsertBehavior;
import kieker.monitoring.queue.behavior.InsertBehavior;
import kieker.monitoring.queue.behavior.TerminateOnFailedInsertBehavior;
import kieker.monitoring.queue.putstrategy.SPBlockingPutStrategy;
import kieker.monitoring.queue.takestrategy.SCBlockingTakeStrategy;
import kieker.monitoring.writer.AbstractMonitoringWriter;
import kieker.monitoring.writer.MonitoringWriterThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WriterController
extends AbstractController
implements IWriterController {
    public static final String PREFIX = WriterController.class.getName() + ".";
    public static final String RECORD_QUEUE_SIZE = "RecordQueueSize";
    public static final String RECORD_QUEUE_INSERT_BEHAVIOR = "RecordQueueInsertBehavior";
    public static final String RECORD_QUEUE_FQN = "RecordQueueFQN";
    private static final Logger LOGGER = LoggerFactory.getLogger(WriterController.class);
    private AbstractMonitoringWriter monitoringWriter;
    private final boolean logMetadataRecord;
    private final int queueCapacity;
    private final BlockingQueue<IMonitoringRecord> writerQueue;
    private MonitoringWriterThread monitoringWriterThread;
    private InsertBehavior<IMonitoringRecord> insertBehavior;

    public WriterController(Configuration configuration) {
        super(configuration);
        this.logMetadataRecord = configuration.getBooleanProperty("kieker.monitoring.metadata");
        this.queueCapacity = configuration.getIntProperty(PREFIX + RECORD_QUEUE_SIZE);
        String queueFqn = configuration.getStringProperty(PREFIX + RECORD_QUEUE_FQN);
        Queue<IMonitoringRecord> queue = this.newQueue(queueFqn, this.queueCapacity);
        if (queue instanceof BlockingQueue) {
            this.writerQueue = (BlockingQueue)queue;
        } else {
            SPBlockingPutStrategy putStrategy = new SPBlockingPutStrategy();
            SCBlockingTakeStrategy takeStrategy = new SCBlockingTakeStrategy();
            this.writerQueue = new BlockingQueueDecorator<IMonitoringRecord>(queue, putStrategy, takeStrategy);
        }
        String writerClassName = configuration.getStringProperty("kieker.monitoring.writer");
        this.monitoringWriter = AbstractController.createAndInitialize(AbstractMonitoringWriter.class, writerClassName, configuration);
        if (this.monitoringWriter == null) {
            this.terminate();
            return;
        }
        this.monitoringWriterThread = new MonitoringWriterThread(this.monitoringWriter, this.writerQueue);
        int recordQueueInsertBehavior = configuration.getIntProperty(PREFIX + RECORD_QUEUE_INSERT_BEHAVIOR);
        if (recordQueueInsertBehavior < 0 || recordQueueInsertBehavior > 5) {
            LOGGER.warn("Unknown value '{}' for {}{}; using default value 0", recordQueueInsertBehavior, PREFIX, RECORD_QUEUE_INSERT_BEHAVIOR);
            recordQueueInsertBehavior = 0;
        }
        switch (recordQueueInsertBehavior) {
            case 1: {
                this.insertBehavior = new BlockOnFailedInsertBehavior<IMonitoringRecord>(this.writerQueue);
                break;
            }
            case 2: {
                this.insertBehavior = new CountOnFailedInsertBehavior<IMonitoringRecord>(this.writerQueue);
                break;
            }
            case 3: {
                this.insertBehavior = new DoNotInsertBehavior<IMonitoringRecord>();
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.insertBehavior = new BypassQueueBehavior(this.monitoringWriter);
                break;
            }
            default: {
                this.insertBehavior = new TerminateOnFailedInsertBehavior<IMonitoringRecord>(this.writerQueue);
            }
        }
    }

    private Queue<IMonitoringRecord> newQueue(String queueFqn, int capacity) {
        try {
            Class<?> clazz = Class.forName(queueFqn);
            Class<Queue> queueClass = clazz.asSubclass(Queue.class);
            Constructor<Queue> constructor = queueClass.getConstructor(Integer.TYPE);
            return constructor.newInstance(capacity);
        }
        catch (ClassNotFoundException | InstantiationException e) {
            LOGGER.warn("An exception occurred", e);
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOGGER.warn("An exception occurred", e);
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOGGER.warn("An exception occurred", e);
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            LOGGER.warn("An exception occurred", e);
            throw new IllegalStateException(e);
        }
    }

    boolean isLogMetadataRecord() {
        return this.logMetadataRecord;
    }

    @Override
    protected final void init() {
        LOGGER.debug("Initializing Writer Controller");
        if (this.monitoringWriterThread != null) {
            this.monitoringWriterThread.start();
        }
    }

    @Override
    protected final void cleanup() {
        LOGGER.debug("Shutting down Writer Controller");
        if (this.monitoringWriterThread != null) {
            this.monitoringWriterThread.terminate();
        }
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder(256).append("WriterController:").append("\n\tQueue type: ").append(this.writerQueue.getClass()).append("\n\tQueue capacity: ").append(this.queueCapacity).append("\n\tInsert behavior (a.k.a. QueueFullBehavior): ").append(this.insertBehavior.toString()).append("\n");
        if (this.monitoringWriter != null) {
            sb.append(this.monitoringWriter.toString());
        } else {
            sb.append("\tNo Monitoring Writer available");
        }
        sb.append('\n');
        return sb.toString();
    }

    @Override
    public final boolean newMonitoringRecord(IMonitoringRecord record) {
        boolean recordSent = this.insertBehavior.insert(record);
        if (!recordSent) {
            LOGGER.error("Error writing the monitoring data. Will terminate monitoring!");
            this.terminate();
        }
        return recordSent;
    }

    @Override
    public void waitForTermination(long timeoutInMs) throws InterruptedException {
        if (this.monitoringWriterThread != null) {
            this.monitoringWriterThread.join(timeoutInMs);
        }
    }

    Thread.State getStateOfMonitoringWriterThread() {
        return this.monitoringWriterThread.getState();
    }
}

