/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.aspectj.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import kieker.common.record.database.AfterDatabaseEvent;
import kieker.common.record.database.BeforeDatabaseEvent;
import kieker.common.record.database.DatabaseFailedEvent;
import kieker.common.record.flow.trace.TraceMetadata;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.TraceRegistry;
import kieker.monitoring.probe.aspectj.AbstractAspectJProbe;
import kieker.monitoring.probe.aspectj.beforeafter.onlycallee.Counter;
import kieker.monitoring.timer.ITimeSource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public abstract class AbstractAspect
extends AbstractAspectJProbe {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAspect.class);
    private static final IMonitoringController CTRLINST = MonitoringController.getInstance();
    private static final ITimeSource TIME = CTRLINST.getTimeSource();
    private static final TraceRegistry TRACEREGISTRY = TraceRegistry.INSTANCE;
    private static final String TECHNOLOGY = "JDBC";
    private static final String LOGGING_PREFIX = "database.AbstractAspect: ";
    private static final String UNDEFINED_VALUE = "<undefined>";
    private final ThreadLocal<Counter> currentStackIndex = new ThreadLocal<Counter>(){

        @Override
        protected Counter initialValue() {
            return new Counter();
        }
    };

    @Pointcut
    public abstract /* synthetic */ void monitoredOperation();

    @Before(value="monitoredOperation() && notWithinKieker()")
    public void beforeOperation(JoinPoint joinPoint) {
        boolean newTrace;
        if (!CTRLINST.isMonitoringEnabled()) {
            return;
        }
        String classSignature = this.getJoinPointClassName(joinPoint);
        if (!CTRLINST.isProbeActivated(classSignature)) {
            return;
        }
        TraceMetadata trace = TRACEREGISTRY.getTrace();
        boolean bl = newTrace = trace == null;
        if (newTrace) {
            trace = TRACEREGISTRY.registerTrace();
            CTRLINST.newMonitoringRecord(trace);
        }
        this.currentStackIndex.get().incrementValue();
        long traceId = trace.getTraceId();
        String operationParameters = this.getJoinPointArguments(joinPoint);
        CTRLINST.newMonitoringRecord(new BeforeDatabaseEvent(TIME.getTime(), classSignature, traceId, trace.getNextOrderId(), operationParameters, TECHNOLOGY));
    }

    @AfterReturning(pointcut="monitoredOperation() && notWithinKieker()", returning="returningObject")
    public void afterReturningOperation(JoinPoint joinPoint, Object returningObject) {
        if (!CTRLINST.isMonitoringEnabled()) {
            return;
        }
        String classSignature = this.getJoinPointClassName(joinPoint);
        if (!CTRLINST.isProbeActivated(classSignature)) {
            return;
        }
        TraceMetadata trace = TRACEREGISTRY.getTrace();
        String operationReturnType = this.getJoinPointReturnType(classSignature);
        String returnedValue = this.getReturnedValue(returningObject, operationReturnType);
        CTRLINST.newMonitoringRecord(new AfterDatabaseEvent(TIME.getTime(), classSignature, trace.getTraceId(), trace.getNextOrderId(), operationReturnType, returnedValue));
    }

    @AfterThrowing(pointcut="monitoredOperation() && notWithinKieker()", throwing="th")
    public void afterThrowing(JoinPoint joinPoint, Throwable th) {
        if (!CTRLINST.isMonitoringEnabled()) {
            return;
        }
        String classSignature = this.getJoinPointClassName(joinPoint);
        if (!CTRLINST.isProbeActivated(classSignature)) {
            return;
        }
        TraceMetadata trace = TRACEREGISTRY.getTrace();
        CTRLINST.newMonitoringRecord(new DatabaseFailedEvent(TIME.getTime(), classSignature, trace.getTraceId(), trace.getNextOrderId(), th.toString()));
    }

    @After(value="monitoredOperation() && notWithinKieker()")
    public void afterOperation(JoinPoint joinPoint) {
        if (!CTRLINST.isMonitoringEnabled()) {
            return;
        }
        String operationSignature = this.getJoinPointClassName(joinPoint);
        if (!CTRLINST.isProbeActivated(operationSignature)) {
            return;
        }
        int stackIndex = this.currentStackIndex.get().decrementValue();
        if (stackIndex == 1) {
            TRACEREGISTRY.unregisterTrace();
        }
    }

    public String getJoinPointClassName(JoinPoint currentJoinPoint) {
        String className = currentJoinPoint.getSignature().toString();
        return className.length() > 0 ? className : UNDEFINED_VALUE;
    }

    private String getJoinPointReturnType(String className) {
        String[] splittedTypeName = className.split(" ");
        return splittedTypeName.length > 0 ? splittedTypeName[0] : UNDEFINED_VALUE;
    }

    public String getJoinPointArguments(JoinPoint currentJoinPoint) {
        String joinPointArgsString = UNDEFINED_VALUE;
        Object[] joinPointArgs = currentJoinPoint.getArgs();
        if (joinPointArgs != null && joinPointArgs.length != 0) {
            joinPointArgsString = this.convertParametersToString(joinPointArgs);
        }
        return joinPointArgsString;
    }

    private String convertParametersToString(Object[] joinPointArgs) {
        String parametersString = UNDEFINED_VALUE;
        StringBuilder sb = new StringBuilder();
        if (joinPointArgs != null) {
            Object[] objectArray = joinPointArgs;
            int n = joinPointArgs.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                sb.append(obj);
                sb.append(';');
                ++n2;
            }
            parametersString = sb.toString();
            parametersString = parametersString.replaceAll("\\s+", " ");
            parametersString = parametersString.trim();
        }
        return parametersString;
    }

    private String getReturnedValue(Object returningObject, String returnType) {
        String returnValue;
        block16: {
            String upperReturnType = returnType.toUpperCase(Locale.getDefault());
            returnValue = UNDEFINED_VALUE;
            if (returnType.equals(UNDEFINED_VALUE) || returningObject == null) break block16;
            int numberOfRows = 0;
            switch (upperReturnType) {
                case "STRING": {
                    returnValue = returningObject.toString();
                    break;
                }
                case "BOOLEAN": {
                    returnValue = returningObject.toString();
                    break;
                }
                case "INT": {
                    numberOfRows = (Integer)returningObject;
                    returnValue = String.valueOf(numberOfRows);
                    break;
                }
                case "RESULTSET": {
                    returnValue = this.getReturnedNumberOfRows(returningObject);
                    break;
                }
            }
        }
        return returnValue;
    }

    private String getReturnedNumberOfRows(Object rawReturnValue) {
        int numberOfRows = 0;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ResultSet rs = (ResultSet)rawReturnValue;){
                while (rs.next()) {
                    ++numberOfRows;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            LOGGER.error("{}getReturnValue: SQL-Exception:", (Object)LOGGING_PREFIX, (Object)e);
        }
        return String.valueOf(numberOfRows);
    }
}

