/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.aspectj.flow.constructorExecutionObjectInterface;

import kieker.common.record.flow.trace.TraceMetadata;
import kieker.common.record.flow.trace.operation.constructor.object.AfterConstructorFailedObjectEvent;
import kieker.common.record.flow.trace.operation.constructor.object.AfterConstructorObjectEvent;
import kieker.common.record.flow.trace.operation.constructor.object.BeforeConstructorObjectInterfaceEvent;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.TraceRegistry;
import kieker.monitoring.probe.aspectj.AbstractAspectJProbe;
import kieker.monitoring.timer.ITimeSource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public abstract class AbstractAspect
extends AbstractAspectJProbe {
    private static final IMonitoringController CTRLINST = MonitoringController.getInstance();
    private static final ITimeSource TIME = CTRLINST.getTimeSource();
    private static final TraceRegistry TRACEREGISTRY = TraceRegistry.INSTANCE;

    @Pointcut
    public abstract /* synthetic */ void monitoredConstructor();

    @Around(value="monitoredConstructor() && this(thisObject) && notWithinKieker()")
    public Object constructor(Object thisObject, ProceedingJoinPoint thisJoinPoint) throws Throwable {
        Object retval;
        boolean newTrace;
        if (!AbstractAspect.CTRLINST.isMonitoringEnabled()) {
            return thisJoinPoint.proceed();
        }
        String operationSignature = this.ajc$superDispatch$kieker_monitoring_probe_aspectj_flow_constructorExecutionObjectInterface_AbstractAspect$signatureToLongString(thisJoinPoint.getSignature());
        if (!AbstractAspect.CTRLINST.isProbeActivated(operationSignature)) {
            return thisJoinPoint.proceed();
        }
        TraceMetadata trace = AbstractAspect.TRACEREGISTRY.getTrace();
        boolean bl = newTrace = trace == null;
        if (newTrace) {
            trace = AbstractAspect.TRACEREGISTRY.registerTrace();
            AbstractAspect.CTRLINST.newMonitoringRecord(trace);
        }
        long traceId = trace.getTraceId();
        String clazz = thisObject.getClass().getName();
        int objectId = System.identityHashCode(thisObject);
        AbstractAspect.CTRLINST.newMonitoringRecord(new BeforeConstructorObjectInterfaceEvent(AbstractAspect.TIME.getTime(), traceId, trace.getNextOrderId(), operationSignature, clazz, objectId, AbstractAspect.getInterface(thisJoinPoint)));
        try {
            try {
                retval = thisJoinPoint.proceed();
            }
            catch (Throwable th) {
                AbstractAspect.CTRLINST.newMonitoringRecord(new AfterConstructorFailedObjectEvent(AbstractAspect.TIME.getTime(), traceId, trace.getNextOrderId(), operationSignature, clazz, th.toString(), objectId));
                throw th;
            }
        }
        finally {
            if (newTrace) {
                AbstractAspect.TRACEREGISTRY.unregisterTrace();
            }
        }
        AbstractAspect.CTRLINST.newMonitoringRecord(new AfterConstructorObjectEvent(AbstractAspect.TIME.getTime(), traceId, trace.getNextOrderId(), operationSignature, clazz, objectId));
        return retval;
    }

    private static final String getInterface(ProceedingJoinPoint thisJoinPoint) {
        Class<?>[] interfaces = thisJoinPoint.getSignature().getDeclaringType().getInterfaces();
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (interfaces.length == 0) {
            String superClassName;
            Class superClass = thisJoinPoint.getSignature().getDeclaringType().getSuperclass();
            if (superClass != null && !"java.lang.Object".equals(superClassName = superClass.getName())) {
                sb.append(superClassName);
            }
        } else {
            int idx = 0;
            while (idx < interfaces.length) {
                sb.append(interfaces[idx].getName());
                if (idx < interfaces.length - 1) {
                    sb.append(", ");
                }
                ++idx;
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public /* synthetic */ String ajc$superDispatch$kieker_monitoring_probe_aspectj_flow_constructorExecutionObjectInterface_AbstractAspect$signatureToLongString(Signature signature) {
        return super.signatureToLongString(signature);
    }
}

