/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.probe.aspectj.spring;

import javax.servlet.http.HttpServletRequest;
import kieker.common.record.flow.trace.BeforeReceivedRemoteEvent;
import kieker.common.record.flow.trace.BeforeSentRemoteEvent;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.monitoring.core.registry.TraceRegistry;
import kieker.monitoring.timer.ITimeSource;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.ClientHttpRequest;

@Aspect
public class RestCommunicationAspect {
    private static final IMonitoringController CTRLINST = MonitoringController.getInstance();
    private static final TraceRegistry TRACEREGISTRY = TraceRegistry.INSTANCE;
    private static final ITimeSource TIME = CTRLINST.getTimeSource();
    private static final String KIEKER_TRACE_ID_HEADER = "kieker-traceId";
    private static final String KIEKER_ORDER_INDEX_HEADER = "kieker-orderIndex";
    private static final String TECHNOLOGY = "REST";
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ RestCommunicationAspect ajc$perSingletonInstance;

    static {
        try {
            RestCommunicationAspect.ajc$perSingletonInstance = new RestCommunicationAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="execution(protected * org.springframework.http.client.support.HttpAccessor.createRequest(..))")
    private /* synthetic */ void requestCreation() {
    }

    @Pointcut(value="execution(protected * org.springframework.web.servlet.FrameworkServlet.service(..))")
    private /* synthetic */ void frameworkServletService() {
    }

    @Before(value="frameworkServletService() && args(request, ..)")
    public void doBeforeDispatcherService(HttpServletRequest request) {
        int orderIndex;
        long traceId;
        String traceIdStr = request.getHeader(KIEKER_TRACE_ID_HEADER);
        if (traceIdStr == null) {
            return;
        }
        try {
            traceId = Long.parseLong(traceIdStr);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        String orderIndexStr = request.getHeader(KIEKER_ORDER_INDEX_HEADER);
        if (orderIndexStr == null) {
            return;
        }
        try {
            orderIndex = Integer.parseInt(orderIndexStr);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (TRACEREGISTRY.getTrace() == null) {
            TRACEREGISTRY.registerTrace();
        }
        BeforeReceivedRemoteEvent newRecord = new BeforeReceivedRemoteEvent(TIME.getTime(), traceId, orderIndex, TRACEREGISTRY.getTrace().getTraceId(), TRACEREGISTRY.getTrace().getNextOrderId());
        CTRLINST.newMonitoringRecord(newRecord);
    }

    @AfterReturning(pointcut="requestCreation()", returning="request")
    public void doAfterRequestCreation(ClientHttpRequest request) {
        long traceId = TRACEREGISTRY.getTrace().getTraceId();
        int orderIndex = TRACEREGISTRY.getTrace().getNextOrderId();
        HttpHeaders headers = request.getHeaders();
        headers.add(KIEKER_TRACE_ID_HEADER, Long.toString(traceId));
        headers.add(KIEKER_ORDER_INDEX_HEADER, Integer.toString(orderIndex));
        CTRLINST.newMonitoringRecord(new BeforeSentRemoteEvent(TIME.getTime(), traceId, orderIndex, TECHNOLOGY));
    }

    public static RestCommunicationAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("kieker.monitoring.probe.aspectj.spring.RestCommunicationAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

